/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.validator;

import java.util.ArrayList;
import org.apache.uima.ruta.ide.validator.RutaCheckerProblemFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension;
import org.eclipse.dltk.core.builder.ISourceLineTracker;

public class RutaProjectChecker
implements IBuildParticipant,
IBuildParticipantExtension {
    public boolean beginBuild(int buildType) {
        return true;
    }

    public void endBuild(IProgressMonitor monitor) {
    }

    public void build(IBuildContext context) throws CoreException {
        Object mdObj = context.get(IBuildContext.ATTR_MODULE_DECLARATION);
        if (!(mdObj instanceof ModuleDeclaration)) {
            return;
        }
        IProblemReporter problemReporter = context.getProblemReporter();
        ISourceModule smod = context.getSourceModule();
        ISourceLineTracker linetracker = context.getLineTracker();
        RutaCheckerProblemFactory problemFactory = new RutaCheckerProblemFactory(smod.getElementName(), linetracker);
        IScriptProject scriptProject = smod.getScriptProject();
        IProject project = scriptProject.getProject();
        IProject[] referencedProjects = project.getReferencedProjects();
        ArrayList<IProject> listOfClosedProjects = new ArrayList<IProject>();
        for (IProject each : referencedProjects) {
            if (each.isOpen()) continue;
            listOfClosedProjects.add(each);
        }
        if (!listOfClosedProjects.isEmpty()) {
            IProblem problem = problemFactory.createClosedProjectsProblem(listOfClosedProjects);
            problemReporter.reportProblem(problem);
        }
    }
}

