/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.om.mapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.mapper.RecordMapper;

public class IntegerMapper
implements RecordMapper<Integer> {
    private static final long serialVersionUID = 1L;
    private final int internalOffset;

    public IntegerMapper() {
        this.internalOffset = 0;
    }

    public IntegerMapper(int offset) {
        this.internalOffset = offset;
    }

    @Override
    public Integer processRow(ResultSet resultSet, int rowOffset, Criteria criteria) throws TorqueException {
        try {
            Integer result = resultSet.getInt(rowOffset + this.internalOffset + 1);
            if (result == 0 && resultSet.wasNull()) {
                return null;
            }
            return result;
        }
        catch (SQLException e) {
            throw new TorqueException("Result could not be mapped to a Integer", e);
        }
    }
}

