/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.interceptor.performance;

import java.lang.reflect.Method;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.Reconfigurable;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.fulcrum.yaafi.framework.interceptor.AvalonInterceptorContext;
import org.apache.fulcrum.yaafi.interceptor.baseservice.BaseInterceptorServiceImpl;
import org.apache.fulcrum.yaafi.interceptor.performance.PerformanceInterceptorService;
import org.apache.fulcrum.yaafi.interceptor.util.ArgumentToStringBuilderImpl;
import org.apache.fulcrum.yaafi.interceptor.util.MethodToStringBuilderImpl;
import org.apache.fulcrum.yaafi.interceptor.util.StopWatch;

public class PerformanceInterceptorServiceImpl
extends BaseInterceptorServiceImpl
implements PerformanceInterceptorService,
Reconfigurable,
Contextualizable,
ThreadSafe {
    private static final int MAX_ARG_LENGTH = 100;
    private static final int BUFFER_LENGTH = 2000;
    private static final String SEPERATOR = ";";
    private int[] tresholdList = new int[5];
    private int maxArgLength;

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.maxArgLength = configuration.getChild("maxArgLength").getValueAsInteger(100);
        Configuration tresholdConfiguration = configuration.getChild("tresholds");
        this.tresholdList[0] = tresholdConfiguration.getChild("fatal").getAttributeAsInteger("millis", 5000);
        this.tresholdList[1] = tresholdConfiguration.getChild("error").getAttributeAsInteger("millis", 1000);
        this.tresholdList[2] = tresholdConfiguration.getChild("warn").getAttributeAsInteger("millis", 500);
        this.tresholdList[3] = tresholdConfiguration.getChild("info").getAttributeAsInteger("millis", 100);
        this.tresholdList[4] = tresholdConfiguration.getChild("debug").getAttributeAsInteger("millis", 10);
    }

    public void reconfigure(Configuration configuration) throws ConfigurationException {
        super.reconfigure(configuration);
        this.configure(configuration);
    }

    public void onEntry(AvalonInterceptorContext interceptorContext) {
        if (this.isServiceMonitored(interceptorContext)) {
            this.createStopWatch(interceptorContext);
        }
    }

    public void onError(AvalonInterceptorContext interceptorContext, Throwable t) {
        if (this.isServiceMonitored(interceptorContext)) {
            StopWatch stopWatch = this.getStopWatch(interceptorContext);
            stopWatch.stop();
            this.log(2, interceptorContext, stopWatch);
        }
    }

    public void onExit(AvalonInterceptorContext interceptorContext, Object result) {
        if (this.isServiceMonitored(interceptorContext) && this.isServiceMonitored(interceptorContext)) {
            StopWatch stopWatch = this.getStopWatch(interceptorContext);
            stopWatch.stop();
            this.log(1, interceptorContext, stopWatch);
        }
    }

    protected void createStopWatch(AvalonInterceptorContext interceptorContext) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        interceptorContext.getRequestContext().put(this.getServiceName(), stopWatch);
    }

    protected StopWatch getStopWatch(AvalonInterceptorContext interceptorContext) {
        return (StopWatch)interceptorContext.getRequestContext().remove(this.getServiceName());
    }

    protected void log(int mode, AvalonInterceptorContext interceptorContext, StopWatch stopWatch) {
        String msg = null;
        long time = stopWatch.getTime();
        if (time >= (long)this.tresholdList[0]) {
            if (this.getLogger().isFatalErrorEnabled()) {
                msg = this.toString(interceptorContext, stopWatch, mode);
                this.getLogger().fatalError(msg);
            }
        } else if (time >= (long)this.tresholdList[1]) {
            if (this.getLogger().isErrorEnabled()) {
                msg = this.toString(interceptorContext, stopWatch, mode);
                this.getLogger().error(msg);
            }
        } else if (time >= (long)this.tresholdList[2]) {
            if (this.getLogger().isWarnEnabled()) {
                msg = this.toString(interceptorContext, stopWatch, mode);
                this.getLogger().warn(msg);
            }
        } else if (time >= (long)this.tresholdList[3]) {
            if (this.getLogger().isInfoEnabled()) {
                msg = this.toString(interceptorContext, stopWatch, mode);
                this.getLogger().info(msg);
            }
        } else if (time >= (long)this.tresholdList[4] && this.getLogger().isDebugEnabled()) {
            msg = this.toString(interceptorContext, stopWatch, mode);
            this.getLogger().debug(msg);
        }
    }

    protected String toString(AvalonInterceptorContext interceptorContext, StopWatch stopWatch, int mode) {
        Method method = interceptorContext.getMethod();
        Object[] args = interceptorContext.getArgs();
        MethodToStringBuilderImpl methodToStringBuilder = new MethodToStringBuilderImpl(method);
        StringBuffer result = new StringBuffer(2000);
        result.append(interceptorContext.getTransactionId());
        result.append(SEPERATOR);
        result.append(interceptorContext.getInvocationId());
        result.append(SEPERATOR);
        result.append(interceptorContext.getInvocationDepth());
        result.append(SEPERATOR);
        result.append(mode);
        result.append(SEPERATOR);
        result.append(interceptorContext.getServiceShorthand());
        result.append(SEPERATOR);
        result.append(method.getName());
        result.append(SEPERATOR);
        result.append(stopWatch.getTime());
        result.append(SEPERATOR);
        result.append(methodToStringBuilder.toString());
        result.append(SEPERATOR);
        result.append(this.toString(args));
        return result.toString();
    }

    protected String toString(Object[] args) {
        StringBuffer result = new StringBuffer();
        ArgumentToStringBuilderImpl toStringBuilder = null;
        if (args == null) {
            args = new Object[]{};
        }
        for (int i = 0; i < args.length; ++i) {
            toStringBuilder = new ArgumentToStringBuilderImpl(args[i], this.maxArgLength, 1);
            result.append("arg[" + i + "]:={");
            result.append(toStringBuilder.toString());
            result.append("}");
            if (i >= args.length - 1) continue;
            result.append(SEPERATOR);
        }
        return result.toString();
    }
}

