/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.entity;

import jakarta.transaction.TransactionSynchronizationRegistry;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Set;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.BeanContext;

public class EntrancyTracker {
    private final ThreadLocal<Set<InstanceKey>> inCallThreadLocal = new ThreadLocal<Set<InstanceKey>>(){

        @Override
        protected Set<InstanceKey> initialValue() {
            return new HashSet<InstanceKey>();
        }
    };
    private final TransactionSynchronizationRegistry synchronizationRegistry;

    public EntrancyTracker(TransactionSynchronizationRegistry synchronizationRegistry) {
        this.synchronizationRegistry = synchronizationRegistry;
    }

    public void enter(BeanContext beanContext, Object primaryKey) throws ApplicationException {
        Set<InstanceKey> inCall;
        if (primaryKey == null || beanContext.isReentrant()) {
            return;
        }
        Object deploymentId = beanContext.getDeploymentID();
        InstanceKey key = new InstanceKey(deploymentId, primaryKey);
        try {
            inCall = (Set<InstanceKey>)this.synchronizationRegistry.getResource(EntrancyTracker.class);
            if (inCall == null) {
                inCall = new HashSet<InstanceKey>();
                this.synchronizationRegistry.putResource(EntrancyTracker.class, inCall);
            }
        }
        catch (IllegalStateException e) {
            inCall = this.inCallThreadLocal.get();
        }
        if (!inCall.add(key)) {
            ApplicationException exception = new ApplicationException(new RemoteException("Attempted reentrant access. Bean " + String.valueOf(deploymentId) + " is not reentrant and instance " + String.valueOf(primaryKey) + " has already been entered : " + String.valueOf(inCall)));
            exception.printStackTrace();
            throw exception;
        }
    }

    public void exit(BeanContext beanContext, Object primaryKey) throws ApplicationException {
        if (primaryKey == null || beanContext.isReentrant()) {
            return;
        }
        Object deploymentId = beanContext.getDeploymentID();
        InstanceKey key = new InstanceKey(deploymentId, primaryKey);
        Set<InstanceKey> inCall = null;
        try {
            inCall = (Set<InstanceKey>)this.synchronizationRegistry.getResource(EntrancyTracker.class);
        }
        catch (IllegalStateException e) {
            inCall = this.inCallThreadLocal.get();
        }
        if (inCall != null) {
            inCall.remove(key);
        }
    }

    private static class InstanceKey {
        private final Object deploymentId;
        private final Object primaryKey;

        public InstanceKey(Object deploymentId, Object primaryKey) {
            this.deploymentId = deploymentId;
            this.primaryKey = primaryKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InstanceKey that = (InstanceKey)o;
            return this.deploymentId.equals(that.deploymentId) && this.primaryKey.equals(that.primaryKey);
        }

        public int hashCode() {
            int result = this.deploymentId.hashCode();
            result = 31 * result + this.primaryKey.hashCode();
            return result;
        }

        public String toString() {
            return String.valueOf(this.deploymentId) + ":" + String.valueOf(this.primaryKey);
        }
    }
}

