/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util;

import java.io.File;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.util.ClassUtil;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.util.ChangeTracker;
import org.apache.openjpa.util.CollectionChangeTracker;
import org.apache.openjpa.util.CollectionChangeTrackerImpl;
import org.apache.openjpa.util.GeneralException;
import org.apache.openjpa.util.GeneratedClasses;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.MapChangeTracker;
import org.apache.openjpa.util.MapChangeTrackerImpl;
import org.apache.openjpa.util.Proxies;
import org.apache.openjpa.util.Proxy;
import org.apache.openjpa.util.ProxyManager;
import org.apache.openjpa.util.UnsupportedException;
import org.apache.openjpa.util.asm.AsmHelper;
import org.apache.openjpa.util.asm.ClassWriterTracker;
import org.apache.openjpa.util.proxy.DelayedArrayListProxy;
import org.apache.openjpa.util.proxy.DelayedHashSetProxy;
import org.apache.openjpa.util.proxy.DelayedLinkedHashSetProxy;
import org.apache.openjpa.util.proxy.DelayedLinkedListProxy;
import org.apache.openjpa.util.proxy.DelayedPriorityQueueProxy;
import org.apache.openjpa.util.proxy.DelayedTreeSetProxy;
import org.apache.openjpa.util.proxy.DelayedVectorProxy;
import org.apache.openjpa.util.proxy.ProxyBean;
import org.apache.openjpa.util.proxy.ProxyCalendar;
import org.apache.openjpa.util.proxy.ProxyCollection;
import org.apache.openjpa.util.proxy.ProxyCollections;
import org.apache.openjpa.util.proxy.ProxyDate;
import org.apache.openjpa.util.proxy.ProxyMap;
import org.apache.openjpa.util.proxy.ProxyMaps;
import org.apache.xbean.asm9.ClassWriter;
import org.apache.xbean.asm9.Label;
import org.apache.xbean.asm9.MethodVisitor;
import org.apache.xbean.asm9.Type;

public class ProxyManagerImpl
implements ProxyManager {
    private static final String PROXY_SUFFIX = "$proxy";
    private static final Localizer _loc = Localizer.forPackage(ProxyManagerImpl.class);
    public static final Type TYPE_OBJECT = Type.getType(Object.class);
    private static long _proxyId = 0L;
    private static final Map _stdCollections = new HashMap();
    private static final Map _stdMaps = new HashMap();
    private final Set<String> _unproxyable = new HashSet<String>();
    private final Map<Class<?>, Proxy> _proxies = new ConcurrentHashMap();
    private boolean _trackChanges = true;
    private boolean _assertType = false;
    private boolean _delayedCollectionLoading = false;

    public ProxyManagerImpl() {
        this._unproxyable.add(TimeZone.class.getName());
    }

    public boolean getTrackChanges() {
        return this._trackChanges;
    }

    public void setTrackChanges(boolean track) {
        this._trackChanges = track;
    }

    public boolean getAssertAllowedType() {
        return this._assertType;
    }

    public void setAssertAllowedType(boolean assertType) {
        this._assertType = assertType;
    }

    @Override
    public boolean getDelayCollectionLoading() {
        return this._delayedCollectionLoading;
    }

    public void setDelayCollectionLoading(boolean delay) {
        this._delayedCollectionLoading = delay;
    }

    public Collection getUnproxyable() {
        return this._unproxyable;
    }

    public void setUnproxyable(String clsNames) {
        if (clsNames != null) {
            this._unproxyable.addAll(Arrays.asList(StringUtil.split(clsNames, ";", 0)));
        }
    }

    @Override
    public Object copyArray(Object orig) {
        if (orig == null) {
            return null;
        }
        try {
            int length = Array.getLength(orig);
            Object array = Array.newInstance(orig.getClass().getComponentType(), length);
            System.arraycopy(orig, 0, array, 0, length);
            return array;
        }
        catch (Exception e) {
            throw new UnsupportedException(_loc.get("bad-array", e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public Collection copyCollection(Collection orig) {
        if (orig == null) {
            return null;
        }
        if (orig instanceof Proxy) {
            return (Collection)((Proxy)((Object)orig)).copy(orig);
        }
        ProxyCollection proxy2 = this.getFactoryProxyCollection(orig.getClass());
        return (Collection)proxy2.copy(orig);
    }

    @Override
    public Proxy newCollectionProxy(Class type, Class elementType, Comparator compare, boolean autoOff) {
        type = this.toProxyableCollectionType(type);
        ProxyCollection proxy2 = this.getFactoryProxyCollection(type);
        return proxy2.newInstance(this._assertType ? elementType : null, compare, this._trackChanges, autoOff);
    }

    @Override
    public Map copyMap(Map orig) {
        if (orig == null) {
            return null;
        }
        if (orig instanceof Proxy) {
            return (Map)((Proxy)((Object)orig)).copy(orig);
        }
        ProxyMap proxy2 = this.getFactoryProxyMap(orig.getClass());
        return (Map)proxy2.copy(orig);
    }

    @Override
    public Proxy newMapProxy(Class type, Class keyType, Class elementType, Comparator compare, boolean autoOff) {
        type = this.toProxyableMapType(type);
        ProxyMap proxy2 = this.getFactoryProxyMap(type);
        return proxy2.newInstance(this._assertType ? keyType : null, this._assertType ? elementType : null, compare, this._trackChanges, autoOff);
    }

    @Override
    public java.util.Date copyDate(java.util.Date orig) {
        if (orig == null) {
            return null;
        }
        if (orig instanceof Proxy) {
            return (java.util.Date)((Proxy)((Object)orig)).copy(orig);
        }
        ProxyDate proxy2 = this.getFactoryProxyDate(orig.getClass());
        return (java.util.Date)proxy2.copy(orig);
    }

    @Override
    public Proxy newDateProxy(Class type) {
        ProxyDate proxy2 = this.getFactoryProxyDate(type);
        return proxy2.newInstance();
    }

    @Override
    public Calendar copyCalendar(Calendar orig) {
        if (orig == null) {
            return null;
        }
        if (orig instanceof Proxy) {
            return (Calendar)((Proxy)((Object)orig)).copy(orig);
        }
        ProxyCalendar proxy2 = this.getFactoryProxyCalendar(orig.getClass());
        return (Calendar)proxy2.copy(orig);
    }

    @Override
    public Proxy newCalendarProxy(Class type, TimeZone zone) {
        if (type == Calendar.class) {
            type = GregorianCalendar.class;
        }
        ProxyCalendar proxy2 = this.getFactoryProxyCalendar(type);
        ProxyCalendar cal = proxy2.newInstance();
        if (zone != null) {
            ((Calendar)((Object)cal)).setTimeZone(zone);
        }
        return cal;
    }

    @Override
    public Object copyCustom(Object orig) {
        if (orig == null) {
            return null;
        }
        if (orig instanceof Proxy) {
            return ((Proxy)orig).copy(orig);
        }
        if (ImplHelper.isManageable(orig)) {
            return null;
        }
        if (orig instanceof Collection) {
            return this.copyCollection((Collection)orig);
        }
        if (orig instanceof Map) {
            return this.copyMap((Map)orig);
        }
        if (orig instanceof java.util.Date) {
            return this.copyDate((java.util.Date)orig);
        }
        if (orig instanceof Calendar) {
            return this.copyCalendar((Calendar)orig);
        }
        ProxyBean proxy2 = this.getFactoryProxyBean(orig);
        return proxy2 == null ? null : proxy2.copy(orig);
    }

    @Override
    public Proxy newCustomProxy(Object orig, boolean autoOff) {
        if (orig == null) {
            return null;
        }
        if (orig instanceof Proxy) {
            return (Proxy)orig;
        }
        if (ImplHelper.isManageable(orig)) {
            return null;
        }
        if (!ProxyManagerImpl.isProxyable(orig.getClass())) {
            return null;
        }
        if (orig instanceof Collection) {
            Comparator comp = orig instanceof SortedSet ? ((SortedSet)orig).comparator() : null;
            Collection c = (Collection)((Object)this.newCollectionProxy(orig.getClass(), null, comp, autoOff));
            c.addAll((Collection)orig);
            return (Proxy)((Object)c);
        }
        if (orig instanceof Map) {
            Comparator comp = orig instanceof SortedMap ? ((SortedMap)orig).comparator() : null;
            Map m = (Map)((Object)this.newMapProxy(orig.getClass(), null, null, comp, autoOff));
            m.putAll((Map)orig);
            return (Proxy)((Object)m);
        }
        if (orig instanceof java.util.Date) {
            java.util.Date d = (java.util.Date)((Object)this.newDateProxy(orig.getClass()));
            d.setTime(((java.util.Date)orig).getTime());
            if (orig instanceof Timestamp) {
                ((Timestamp)d).setNanos(((Timestamp)orig).getNanos());
            }
            return (Proxy)((Object)d);
        }
        if (orig instanceof Calendar) {
            Calendar c = (Calendar)((Object)this.newCalendarProxy(orig.getClass(), ((Calendar)orig).getTimeZone()));
            c.setTimeInMillis(((Calendar)orig).getTimeInMillis());
            return (Proxy)((Object)c);
        }
        ProxyBean proxy2 = this.getFactoryProxyBean(orig);
        return proxy2 == null ? null : proxy2.newInstance(orig);
    }

    protected Class toProxyableCollectionType(Class type) {
        if (type.getName().endsWith(PROXY_SUFFIX)) {
            type = type.getSuperclass();
        } else if (type.isInterface()) {
            if ((type = ProxyManagerImpl.toConcreteType(type, _stdCollections)) == null) {
                throw new UnsupportedException(_loc.get("no-proxy-intf", type));
            }
        } else if (Modifier.isAbstract(type.getModifiers())) {
            throw new UnsupportedException(_loc.get("no-proxy-abstract", type));
        }
        return type;
    }

    protected Class toProxyableMapType(Class type) {
        if (type.getName().endsWith(PROXY_SUFFIX)) {
            type = type.getSuperclass();
        } else if (type.isInterface()) {
            if ((type = ProxyManagerImpl.toConcreteType(type, _stdMaps)) == null) {
                throw new UnsupportedException(_loc.get("no-proxy-intf", type));
            }
        } else if (Modifier.isAbstract(type.getModifiers())) {
            throw new UnsupportedException(_loc.get("no-proxy-abstract", type));
        }
        return type;
    }

    private static Class toConcreteType(Class intf, Map concretes) {
        Class<?>[] intfs;
        Class concrete = (Class)concretes.get(intf);
        if (concrete != null) {
            return concrete;
        }
        for (Class<?> aClass : intfs = intf.getInterfaces()) {
            concrete = ProxyManagerImpl.toConcreteType(aClass, concretes);
            if (concrete == null) continue;
            return concrete;
        }
        return null;
    }

    private ProxyMap getFactoryProxyMap(Class type) {
        ProxyMap proxy2 = (ProxyMap)this._proxies.get(type);
        if (proxy2 == null) {
            ClassLoader l = GeneratedClasses.getMostDerivedLoader(type, ProxyMap.class);
            Class pcls = this.loadBuildTimeProxy(type, l);
            if (pcls == null) {
                pcls = this.generateAndLoadProxyMap(type, true, l);
            }
            proxy2 = (ProxyMap)this.instantiateProxy(pcls, null, null);
            this._proxies.put(type, proxy2);
        }
        return proxy2;
    }

    private ProxyDate getFactoryProxyDate(Class type) {
        ProxyDate proxy2 = (ProxyDate)this._proxies.get(type);
        if (proxy2 == null) {
            ClassLoader l = GeneratedClasses.getMostDerivedLoader(type, ProxyDate.class);
            Class pcls = this.loadBuildTimeProxy(type, l);
            if (pcls == null) {
                pcls = this.generateAndLoadProxyDate(type, true, l);
            }
            proxy2 = (ProxyDate)this.instantiateProxy(pcls, null, null);
            this._proxies.put(type, proxy2);
        }
        return proxy2;
    }

    private ProxyCalendar getFactoryProxyCalendar(Class type) {
        ProxyCalendar proxy2 = (ProxyCalendar)this._proxies.get(type);
        if (proxy2 == null) {
            ClassLoader l = GeneratedClasses.getMostDerivedLoader(type, ProxyCalendar.class);
            Class pcls = this.loadBuildTimeProxy(type, l);
            if (pcls == null) {
                pcls = this.generateAndLoadProxyCalendar(type, true, l);
            }
            proxy2 = (ProxyCalendar)this.instantiateProxy(pcls, null, null);
            this._proxies.put(type, proxy2);
        }
        return proxy2;
    }

    private ProxyCollection getFactoryProxyCollection(Class type) {
        ProxyCollection proxy2 = (ProxyCollection)this._proxies.get(type);
        if (proxy2 == null) {
            ClassLoader l = GeneratedClasses.getMostDerivedLoader(type, ProxyCollection.class);
            Class pcls = this.loadBuildTimeProxy(type, l);
            if (pcls == null) {
                pcls = this.generateAndLoadProxyCollection(type, true, l);
            }
            proxy2 = (ProxyCollection)this.instantiateProxy(pcls, null, null);
            this._proxies.put(type, proxy2);
        }
        return proxy2;
    }

    private ProxyBean getFactoryProxyBean(Object orig) {
        Class<?> type = orig.getClass();
        if (this.isUnproxyable(type)) {
            return null;
        }
        ProxyBean proxy2 = (ProxyBean)this._proxies.get(type);
        if (proxy2 == null) {
            ClassLoader l = GeneratedClasses.getMostDerivedLoader(type, ProxyBean.class);
            Class pcls = this.loadBuildTimeProxy(type, l);
            if (pcls == null) {
                pcls = this.generateAndLoadProxyBean(type, true, l);
            }
            if (pcls != null) {
                proxy2 = (ProxyBean)this.instantiateProxy(pcls, this.findCopyConstructor(type), new Object[]{orig});
            }
            if (proxy2 == null) {
                this._unproxyable.add(type.getName());
            } else {
                this._proxies.put(type, proxy2);
            }
        }
        return proxy2;
    }

    protected boolean isUnproxyable(Class type) {
        while (type != null && type != Object.class) {
            if (this._unproxyable.contains(type.getName())) {
                return true;
            }
            type = type.getSuperclass();
        }
        return false;
    }

    protected Class loadBuildTimeProxy(Class type, ClassLoader loader) {
        try {
            Class<?> proxyClass = null;
            if (this._delayedCollectionLoading && (proxyClass = this.loadDelayedProxy(type)) != null) {
                return proxyClass;
            }
            return Class.forName(ProxyManagerImpl.getProxyClassName(type, false), true, loader);
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected Class<?> loadDelayedProxy(Class<?> type) {
        if (type.equals(ArrayList.class)) {
            return DelayedArrayListProxy.class;
        }
        if (type.equals(HashSet.class)) {
            return DelayedHashSetProxy.class;
        }
        if (type.equals(LinkedList.class)) {
            return DelayedLinkedListProxy.class;
        }
        if (type.equals(Vector.class)) {
            return DelayedVectorProxy.class;
        }
        if (type.equals(LinkedHashSet.class)) {
            return DelayedLinkedHashSetProxy.class;
        }
        if (type.equals(SortedSet.class) || type.equals(TreeSet.class)) {
            return DelayedTreeSetProxy.class;
        }
        if (type.equals(PriorityQueue.class)) {
            return DelayedPriorityQueueProxy.class;
        }
        return null;
    }

    private Proxy instantiateProxy(Class cls, Constructor cons, Object[] args) {
        try {
            if (cons != null) {
                return (Proxy)cls.getConstructor(cons.getParameterTypes()).newInstance(args);
            }
            return (Proxy)AccessController.doPrivileged(J2DoPrivHelper.newInstanceAction(cls));
        }
        catch (InstantiationException ie) {
            throw new UnsupportedException(_loc.get("cant-newinstance", cls.getSuperclass().getName()));
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof InstantiationException) {
                throw new UnsupportedException(_loc.get("cant-newinstance", cls.getSuperclass().getName()));
            }
            throw new GeneralException(cls.getName()).setCause(e);
        }
        catch (Throwable t) {
            throw new GeneralException(cls.getName()).setCause(t);
        }
    }

    protected static String getProxyClassName(Class type, boolean runtime) {
        Object id = runtime ? "$" + ProxyManagerImpl.nextProxyId() : "";
        return ClassUtil.getPackageName(ProxyManagerImpl.class) + "." + type.getName().replace('.', '$') + (String)id + PROXY_SUFFIX;
    }

    private static void assertNotFinal(Class type) {
        if (Modifier.isFinal(type.getModifiers())) {
            throw new UnsupportedException(_loc.get("no-proxy-final", type));
        }
    }

    private static boolean isProxyable(Class<?> cls) {
        int mod = cls.getModifiers();
        if (Modifier.isFinal(mod)) {
            return false;
        }
        if (Modifier.isProtected(mod) || Modifier.isPublic(mod)) {
            return true;
        }
        return cls.getPackage().getName().equals("org.apache.openjpa.util");
    }

    private Class generateAndLoadProxyDate(Class type, boolean runtime, ClassLoader l) {
        String proxyClassName = ProxyManagerImpl.getProxyClassName(type, runtime);
        byte[] classBytes = this.generateProxyDateBytecode(type, runtime, proxyClassName);
        if (classBytes == null) {
            return null;
        }
        return GeneratedClasses.loadAsmClass(proxyClassName, classBytes, ProxyDate.class, l);
    }

    private Class generateAndLoadProxyCalendar(Class type, boolean runtime, ClassLoader l) {
        String proxyClassName = ProxyManagerImpl.getProxyClassName(type, runtime);
        byte[] classBytes = this.generateProxyCalendarBytecode(type, runtime, proxyClassName);
        if (classBytes == null) {
            return null;
        }
        return GeneratedClasses.loadAsmClass(proxyClassName, classBytes, ProxyDate.class, l);
    }

    private Class generateAndLoadProxyCollection(Class type, boolean runtime, ClassLoader l) {
        String proxyClassName = ProxyManagerImpl.getProxyClassName(type, runtime);
        byte[] classBytes = this.generateProxyCollectionBytecode(type, runtime, proxyClassName);
        if (classBytes == null) {
            return null;
        }
        return GeneratedClasses.loadAsmClass(proxyClassName, classBytes, ProxyCollection.class, l);
    }

    private Class generateAndLoadProxyMap(Class type, boolean runtime, ClassLoader l) {
        String proxyClassName = ProxyManagerImpl.getProxyClassName(type, runtime);
        byte[] classBytes = this.generateProxyMapBytecode(type, runtime, proxyClassName);
        if (classBytes == null) {
            return null;
        }
        return GeneratedClasses.loadAsmClass(proxyClassName, classBytes, ProxyMap.class, l);
    }

    private Class generateAndLoadProxyBean(Class type, boolean runtime, ClassLoader l) {
        String proxyClassName = ProxyManagerImpl.getProxyClassName(type, runtime);
        byte[] classBytes = this.generateProxyBeanBytecode(type, runtime, proxyClassName);
        if (classBytes == null) {
            return null;
        }
        return GeneratedClasses.loadAsmClass(proxyClassName, classBytes, ProxyBean.class, l);
    }

    protected byte[] generateProxyDateBytecode(Class type, boolean runtime, String proxyClassName) {
        ProxyManagerImpl.assertNotFinal(type);
        String proxyClassDef = proxyClassName.replace('.', '/');
        String superClassFileNname = Type.getInternalName((Class)type);
        String[] interfaceNames = new String[]{Type.getInternalName(ProxyDate.class)};
        ClassWriter cw = new ClassWriter(2);
        cw.visit(55, 33, proxyClassDef, null, superClassFileNname, interfaceNames);
        ClassWriterTracker ct = new ClassWriterTracker(cw);
        String classFileName = runtime ? type.getName() : proxyClassDef;
        cw.visitSource(classFileName + ".java", null);
        this.delegateConstructors(ct, type, superClassFileNname);
        this.addInstanceVariables(ct);
        this.addProxyMethods(ct, true, proxyClassDef, type);
        this.addProxyDateMethods(ct, proxyClassDef, type);
        this.proxySetters(ct, proxyClassDef, type);
        this.addWriteReplaceMethod(ct, proxyClassDef, runtime);
        return cw.toByteArray();
    }

    protected byte[] generateProxyCalendarBytecode(Class type, boolean runtime, String proxyClassName) {
        ProxyManagerImpl.assertNotFinal(type);
        String proxyClassDef = proxyClassName.replace('.', '/');
        String superClassFileNname = Type.getInternalName((Class)type);
        String[] interfaceNames = new String[]{Type.getInternalName(ProxyCalendar.class)};
        ClassWriter cw = new ClassWriter(2);
        cw.visit(55, 33, proxyClassDef, null, superClassFileNname, interfaceNames);
        ClassWriterTracker ct = new ClassWriterTracker(cw);
        String classFileName = runtime ? type.getName() : proxyClassDef;
        cw.visitSource(classFileName + ".java", null);
        this.delegateConstructors(ct, type, superClassFileNname);
        this.addInstanceVariables(ct);
        this.addProxyMethods(ct, true, proxyClassDef, type);
        this.addProxyCalendarMethods(ct, proxyClassDef, type);
        this.proxySetters(ct, proxyClassDef, type);
        this.addWriteReplaceMethod(ct, proxyClassDef, runtime);
        return cw.toByteArray();
    }

    protected byte[] generateProxyCollectionBytecode(Class type, boolean runtime, String proxyClassName) {
        ProxyManagerImpl.assertNotFinal(type);
        String proxyClassDef = proxyClassName.replace('.', '/');
        String superClassFileNname = Type.getInternalName((Class)type);
        String[] interfaceNames = new String[]{Type.getInternalName(ProxyCollection.class)};
        ClassWriter cw = new ClassWriter(2);
        cw.visit(55, 33, proxyClassDef, null, superClassFileNname, interfaceNames);
        ClassWriterTracker ct = new ClassWriterTracker(cw);
        String classFileName = runtime ? type.getName() : proxyClassDef;
        cw.visitSource(classFileName + ".java", null);
        this.delegateConstructors(ct, type, superClassFileNname);
        this.addInstanceVariables(ct);
        this.addProxyMethods(ct, false, proxyClassDef, type);
        this.addProxyCollectionMethods(ct, proxyClassDef, type);
        this.proxyRecognizedMethods(ct, proxyClassDef, type, ProxyCollections.class, ProxyCollection.class);
        this.proxySetters(ct, proxyClassDef, type);
        this.addWriteReplaceMethod(ct, proxyClassDef, runtime);
        return cw.toByteArray();
    }

    protected byte[] generateProxyMapBytecode(Class type, boolean runtime, String proxyClassName) {
        ProxyManagerImpl.assertNotFinal(type);
        String proxyClassDef = proxyClassName.replace('.', '/');
        String superClassFileNname = Type.getInternalName((Class)type);
        String[] interfaceNames = new String[]{Type.getInternalName(ProxyMap.class)};
        ClassWriter cw = new ClassWriter(2);
        cw.visit(55, 33, proxyClassDef, null, superClassFileNname, interfaceNames);
        ClassWriterTracker ct = new ClassWriterTracker(cw);
        String classFileName = runtime ? type.getName() : proxyClassDef;
        cw.visitSource(classFileName + ".java", null);
        this.delegateConstructors(ct, type, superClassFileNname);
        this.addInstanceVariables(ct);
        this.addProxyMethods(ct, false, proxyClassDef, type);
        this.addProxyMapMethods(ct, proxyClassDef, type);
        this.proxyRecognizedMethods(ct, proxyClassDef, type, ProxyMaps.class, ProxyMap.class);
        this.proxySetters(ct, proxyClassDef, type);
        this.addWriteReplaceMethod(ct, proxyClassDef, runtime);
        return cw.toByteArray();
    }

    protected byte[] generateProxyBeanBytecode(Class type, boolean runtime, String proxyClassName) {
        if (Modifier.isFinal(type.getModifiers())) {
            return null;
        }
        if (ImplHelper.isManagedType(null, type)) {
            return null;
        }
        Constructor<?> cons = this.findCopyConstructor(type);
        if (cons == null) {
            Constructor<?>[] cs = type.getConstructors();
            for (int i = 0; cons == null && i < cs.length; ++i) {
                if (cs[i].getParameterTypes().length != 0) continue;
                cons = cs[i];
            }
            if (cons == null) {
                return null;
            }
        }
        String proxyClassDef = proxyClassName.replace('.', '/');
        String superClassFileNname = Type.getInternalName((Class)type);
        String[] interfaceNames = new String[]{Type.getInternalName(ProxyBean.class)};
        ClassWriter cw = new ClassWriter(2);
        cw.visit(55, 33, proxyClassDef, null, superClassFileNname, interfaceNames);
        ClassWriterTracker ct = new ClassWriterTracker(cw);
        String classFileName = runtime ? type.getName() : proxyClassDef;
        cw.visitSource(classFileName + ".java", null);
        this.delegateConstructors(ct, type, superClassFileNname);
        this.addInstanceVariables(ct);
        this.addProxyMethods(ct, true, proxyClassDef, type);
        this.addProxyBeanMethods(ct, proxyClassDef, type, cons);
        if (!this.proxySetters(ct, proxyClassDef, type)) {
            return null;
        }
        this.addWriteReplaceMethod(ct, proxyClassDef, runtime);
        return cw.toByteArray();
    }

    private void addProxyBeanMethods(ClassWriterTracker ct, String proxyClassDef, Class type, Constructor cons) {
        MethodVisitor mv = ct.visitMethod(1, "copy", Type.getMethodDescriptor((Type)TYPE_OBJECT, (Type[])new Type[]{TYPE_OBJECT}), null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, Type.getInternalName((Class)type));
        mv.visitInsn(89);
        Class<?>[] params = cons.getParameterTypes();
        if (params.length == 1) {
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, Type.getInternalName(params[0]));
        }
        mv.visitMethodInsn(183, Type.getInternalName((Class)type), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])AsmHelper.getParamTypes(params)), false);
        int beanVarPos = params.length + 2;
        if (params.length == 0) {
            mv.visitVarInsn(58, beanVarPos);
            this.copyBeanProperties(mv, type, beanVarPos);
            mv.visitVarInsn(25, beanVarPos);
        }
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        mv = ct.visitMethod(1, "newInstance", Type.getMethodDescriptor((Type)Type.getType(ProxyBean.class), (Type[])new Type[]{Type.getType(Object.class)}), null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, proxyClassDef);
        mv.visitInsn(89);
        params = cons.getParameterTypes();
        if (params.length == 1) {
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, Type.getInternalName(params[0]));
        }
        mv.visitMethodInsn(183, proxyClassDef, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])AsmHelper.getParamTypes(params)), false);
        beanVarPos = params.length + 2;
        if (params.length == 0) {
            mv.visitVarInsn(58, beanVarPos);
            this.copyBeanProperties(mv, type, beanVarPos);
            mv.visitVarInsn(25, beanVarPos);
        }
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void copyBeanProperties(MethodVisitor mv, Class type, int copyVarPos) {
        Method[] meths;
        for (Method meth : meths = type.getMethods()) {
            Method getter;
            int mods = meth.getModifiers();
            if (!Modifier.isPublic(mods) || Modifier.isStatic(mods) || !ProxyManagerImpl.startsWith(meth.getName(), "set") || meth.getParameterTypes().length != 1 || (getter = this.findGetter(type, meth)) == null) continue;
            mv.visitVarInsn(25, copyVarPos);
            mv.visitVarInsn(25, copyVarPos - 1);
            mv.visitTypeInsn(192, Type.getInternalName((Class)type));
            mv.visitMethodInsn(182, Type.getInternalName((Class)type), getter.getName(), Type.getMethodDescriptor((Method)getter), false);
            mv.visitMethodInsn(182, Type.getInternalName((Class)type), meth.getName(), Type.getMethodDescriptor((Method)meth), false);
        }
    }

    private void addProxyCollectionMethods(ClassWriterTracker ct, String proxyClassDef, Class type) {
        Class[] params;
        ct.getCw().visitField(130, "changeTracker", Type.getDescriptor(CollectionChangeTracker.class), null, null).visitEnd();
        MethodVisitor mv = ct.visitMethod(1, "getChangeTracker", Type.getMethodDescriptor((Type)Type.getType(ChangeTracker.class), (Type[])new Type[0]), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, proxyClassDef, "changeTracker", Type.getDescriptor(CollectionChangeTracker.class));
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        Constructor cons = this.findCopyConstructor(type);
        if (cons == null && SortedSet.class.isAssignableFrom(type)) {
            cons = ProxyManagerImpl.findComparatorConstructor(type);
        }
        Class[] params2 = cons == null ? new Class[]{} : cons.getParameterTypes();
        MethodVisitor mv2 = ct.visitMethod(1, "copy", Type.getMethodDescriptor((Type)TYPE_OBJECT, (Type[])new Type[]{TYPE_OBJECT}), null, null);
        mv2.visitCode();
        mv2.visitTypeInsn(187, Type.getInternalName((Class)type));
        mv2.visitInsn(89);
        if (params2.length == 1) {
            mv2.visitVarInsn(25, 1);
            if (params2[0] == Comparator.class) {
                mv2.visitTypeInsn(192, Type.getInternalName(SortedSet.class));
                mv2.visitMethodInsn(185, Type.getInternalName(SortedSet.class), "comparator", Type.getMethodDescriptor((Type)Type.getType(Comparator.class), (Type[])new Type[0]), true);
            } else {
                mv2.visitTypeInsn(192, Type.getInternalName((Class)params2[0]));
            }
        }
        mv2.visitMethodInsn(183, Type.getInternalName((Class)type), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])AsmHelper.getParamTypes(params2)), false);
        if (params2.length == 0 || params2[0] == Comparator.class) {
            mv2.visitInsn(89);
            mv2.visitVarInsn(25, 1);
            mv2.visitTypeInsn(192, Type.getInternalName(Collection.class));
            mv2.visitMethodInsn(182, Type.getInternalName((Class)type), "addAll", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.getType(Collection.class)}), false);
            mv2.visitInsn(87);
        }
        mv2.visitInsn(176);
        mv2.visitMaxs(-1, -1);
        mv2.visitEnd();
        ct.getCw().visitField(130, "elementType", Type.getDescriptor(Class.class), null, null).visitEnd();
        mv = ct.visitMethod(1, "getElementType", Type.getMethodDescriptor((Type)Type.getType(Class.class), (Type[])new Type[0]), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, proxyClassDef, "elementType", Type.getDescriptor(Class.class));
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        mv = ct.visitMethod(1, "newInstance", Type.getMethodDescriptor((Type)Type.getType(ProxyCollection.class), (Type[])new Type[]{Type.getType(Class.class), Type.getType(Comparator.class), Type.BOOLEAN_TYPE, Type.BOOLEAN_TYPE}), null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, proxyClassDef);
        mv.visitInsn(89);
        Constructor cons2 = ProxyManagerImpl.findComparatorConstructor(type);
        Class[] classArray = params = cons2 == null ? new Class[]{} : cons2.getParameterTypes();
        if (params.length == 1) {
            mv.visitVarInsn(25, 2);
        }
        mv.visitMethodInsn(183, proxyClassDef, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])AsmHelper.getParamTypes(params)), false);
        mv.visitVarInsn(58, 5);
        mv.visitVarInsn(25, 5);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, proxyClassDef, "elementType", Type.getDescriptor(Class.class));
        mv.visitVarInsn(21, 3);
        Label lNotTrack = new Label();
        mv.visitJumpInsn(153, lNotTrack);
        mv.visitVarInsn(25, 5);
        mv.visitTypeInsn(187, Type.getInternalName(CollectionChangeTrackerImpl.class));
        mv.visitInsn(89);
        mv.visitVarInsn(25, 5);
        mv.visitInsn(this.allowsDuplicates(type) ? 4 : 3);
        mv.visitInsn(this.isOrdered(type) ? 4 : 3);
        mv.visitVarInsn(21, 4);
        mv.visitMethodInsn(183, Type.getInternalName(CollectionChangeTrackerImpl.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Collection.class), Type.BOOLEAN_TYPE, Type.BOOLEAN_TYPE, Type.BOOLEAN_TYPE}), false);
        mv.visitFieldInsn(181, proxyClassDef, "changeTracker", Type.getDescriptor(CollectionChangeTracker.class));
        mv.visitLabel(lNotTrack);
        mv.visitVarInsn(25, 5);
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void addProxyMapMethods(ClassWriterTracker ct, String proxyClassDef, Class type) {
        Class[] params;
        ct.getCw().visitField(130, "changeTracker", Type.getDescriptor(MapChangeTracker.class), null, null).visitEnd();
        MethodVisitor mv = ct.visitMethod(1, "getChangeTracker", Type.getMethodDescriptor((Type)Type.getType(ChangeTracker.class), (Type[])new Type[0]), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, proxyClassDef, "changeTracker", Type.getDescriptor(MapChangeTracker.class));
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        Constructor cons = this.findCopyConstructor(type);
        if (cons == null && SortedMap.class.isAssignableFrom(type)) {
            cons = ProxyManagerImpl.findComparatorConstructor(type);
        }
        Class[] params2 = cons == null ? new Class[]{} : cons.getParameterTypes();
        MethodVisitor mv2 = ct.visitMethod(1, "copy", Type.getMethodDescriptor((Type)TYPE_OBJECT, (Type[])new Type[]{TYPE_OBJECT}), null, null);
        mv2.visitCode();
        mv2.visitTypeInsn(187, Type.getInternalName((Class)type));
        mv2.visitInsn(89);
        if (params2.length == 1) {
            mv2.visitVarInsn(25, 1);
            if (params2[0] == Comparator.class) {
                mv2.visitTypeInsn(192, Type.getInternalName(SortedMap.class));
                mv2.visitMethodInsn(185, Type.getInternalName(SortedMap.class), "comparator", Type.getMethodDescriptor((Type)Type.getType(Comparator.class), (Type[])new Type[0]), true);
            } else {
                mv2.visitTypeInsn(192, Type.getInternalName((Class)params2[0]));
            }
        }
        mv2.visitMethodInsn(183, Type.getInternalName((Class)type), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])AsmHelper.getParamTypes(params2)), false);
        if (params2.length == 0 || params2[0] == Comparator.class) {
            mv2.visitInsn(89);
            mv2.visitVarInsn(25, 1);
            mv2.visitTypeInsn(192, Type.getInternalName(Map.class));
            mv2.visitMethodInsn(182, Type.getInternalName((Class)type), "putAll", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Map.class)}), false);
        }
        mv2.visitInsn(176);
        mv2.visitMaxs(-1, -1);
        mv2.visitEnd();
        ct.getCw().visitField(130, "keyType", Type.getDescriptor(Class.class), null, null).visitEnd();
        mv = ct.visitMethod(1, "getKeyType", Type.getMethodDescriptor((Type)Type.getType(Class.class), (Type[])new Type[0]), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, proxyClassDef, "keyType", Type.getDescriptor(Class.class));
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        ct.getCw().visitField(130, "valueType", Type.getDescriptor(Class.class), null, null).visitEnd();
        mv = ct.visitMethod(1, "getValueType", Type.getMethodDescriptor((Type)Type.getType(Class.class), (Type[])new Type[0]), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, proxyClassDef, "valueType", Type.getDescriptor(Class.class));
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        mv = ct.visitMethod(1, "newInstance", Type.getMethodDescriptor((Type)Type.getType(ProxyMap.class), (Type[])new Type[]{Type.getType(Class.class), Type.getType(Class.class), Type.getType(Comparator.class), Type.BOOLEAN_TYPE, Type.BOOLEAN_TYPE}), null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, proxyClassDef);
        mv.visitInsn(89);
        Constructor cons2 = ProxyManagerImpl.findComparatorConstructor(type);
        Class[] classArray = params = cons2 == null ? new Class[]{} : cons2.getParameterTypes();
        if (params.length == 1) {
            mv.visitVarInsn(25, 3);
        }
        mv.visitMethodInsn(183, proxyClassDef, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])AsmHelper.getParamTypes(params)), false);
        mv.visitVarInsn(58, 6);
        mv.visitVarInsn(25, 6);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, proxyClassDef, "keyType", Type.getDescriptor(Class.class));
        mv.visitVarInsn(25, 6);
        mv.visitVarInsn(25, 2);
        mv.visitFieldInsn(181, proxyClassDef, "valueType", Type.getDescriptor(Class.class));
        mv.visitVarInsn(21, 4);
        Label lNotTrack = new Label();
        mv.visitJumpInsn(153, lNotTrack);
        mv.visitVarInsn(25, 6);
        mv.visitTypeInsn(187, Type.getInternalName(MapChangeTrackerImpl.class));
        mv.visitInsn(89);
        mv.visitVarInsn(25, 6);
        mv.visitVarInsn(21, 5);
        mv.visitMethodInsn(183, Type.getInternalName(MapChangeTrackerImpl.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Map.class), Type.BOOLEAN_TYPE}), false);
        mv.visitFieldInsn(181, proxyClassDef, "changeTracker", Type.getDescriptor(MapChangeTracker.class));
        mv.visitLabel(lNotTrack);
        mv.visitVarInsn(25, 6);
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void proxyRecognizedMethods(ClassWriterTracker ct, String proxyClassDef, Class<?> type, Class<?> helper, Class<?> proxyType) {
        Method[] meths;
        for (Method meth : meths = type.getMethods()) {
            if (meth.getReturnType().getName().contains("KeySetView")) continue;
            Class[] helperParams = ProxyManagerImpl.toHelperParameters(meth.getParameterTypes(), proxyType);
            try {
                Method match = helper.getMethod(meth.getName(), helperParams);
                this.proxyOverrideMethod(ct, meth, match, helperParams);
                continue;
            }
            catch (NoSuchMethodException match) {
            }
            catch (Exception e) {
                throw new GeneralException(e);
            }
            Method before = null;
            try {
                before = helper.getMethod("before" + StringUtil.capitalize(meth.getName()), helperParams);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception e) {
                throw new GeneralException(e);
            }
            Method after = null;
            Class[] afterParams = null;
            try {
                afterParams = ProxyManagerImpl.toHelperAfterParameters(helperParams, meth.getReturnType(), before == null ? Void.TYPE : before.getReturnType());
                after = helper.getMethod("after" + StringUtil.capitalize(meth.getName()), afterParams);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception e) {
                throw new GeneralException(e);
            }
            if (before == null && after == null) continue;
            this.proxyBeforeAfterMethod(ct, type, meth, helperParams, before, after, afterParams);
        }
    }

    private void proxyOverrideMethod(ClassWriterTracker ct, Method meth, Method helper, Class[] helperParams) {
        MethodVisitor mv = ct.visitMethod(meth.getModifiers() & 0xFFFFFFDF, meth.getName(), Type.getMethodDescriptor((Method)meth), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        for (int i = 1; i < helperParams.length; ++i) {
            mv.visitVarInsn(AsmHelper.getLoadInsn(helperParams[i]), i);
        }
        mv.visitMethodInsn(184, Type.getInternalName(helper.getDeclaringClass()), helper.getName(), Type.getMethodDescriptor((Method)helper), false);
        mv.visitInsn(AsmHelper.getReturnInsn(meth.getReturnType()));
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void proxyBeforeAfterMethod(ClassWriterTracker ct, Class type, Method meth, Class[] helperParams, Method before, Method after, Class[] afterParams) {
        int i;
        MethodVisitor mv = ct.visitMethod(meth.getModifiers() & 0xFFFFFFDF, meth.getName(), Type.getMethodDescriptor((Method)meth), null, null);
        mv.visitCode();
        int beforeRetPos = -1;
        int variableNr = helperParams.length;
        if (before != null) {
            mv.visitVarInsn(25, 0);
            for (i = 1; i < helperParams.length; ++i) {
                mv.visitVarInsn(AsmHelper.getLoadInsn(helperParams[i]), i);
            }
            mv.visitMethodInsn(184, Type.getInternalName(before.getDeclaringClass()), before.getName(), Type.getMethodDescriptor((Method)before), false);
            if (after != null && before.getReturnType() != Void.TYPE) {
                beforeRetPos = variableNr++;
                mv.visitVarInsn(AsmHelper.getStoreInsn(before.getReturnType()), beforeRetPos);
            }
        }
        mv.visitVarInsn(25, 0);
        for (i = 1; i < helperParams.length; ++i) {
            mv.visitVarInsn(AsmHelper.getLoadInsn(helperParams[i]), i);
        }
        mv.visitMethodInsn(183, Type.getInternalName((Class)type), meth.getName(), Type.getMethodDescriptor((Method)meth), false);
        if (after != null) {
            int retPos = -1;
            if (meth.getReturnType() != Void.TYPE) {
                retPos = variableNr++;
                mv.visitVarInsn(AsmHelper.getStoreInsn(meth.getReturnType()), retPos);
            }
            mv.visitVarInsn(25, 0);
            for (int i2 = 1; i2 < helperParams.length; ++i2) {
                mv.visitVarInsn(AsmHelper.getLoadInsn(helperParams[i2]), i2);
            }
            if (retPos != -1) {
                mv.visitVarInsn(AsmHelper.getLoadInsn(meth.getReturnType()), retPos);
            }
            if (beforeRetPos != -1) {
                mv.visitVarInsn(AsmHelper.getLoadInsn(before.getReturnType()), beforeRetPos);
            }
            mv.visitMethodInsn(184, Type.getInternalName(after.getDeclaringClass()), after.getName(), Type.getMethodDescriptor((Method)after), false);
        }
        mv.visitInsn(AsmHelper.getReturnInsn(meth.getReturnType()));
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void addInstanceVariables(ClassWriterTracker ct) {
        ct.getCw().visitField(130, "sm", Type.getDescriptor(OpenJPAStateManager.class), null, null).visitEnd();
        ct.getCw().visitField(130, "field", Type.getDescriptor(Integer.TYPE), null, null).visitEnd();
    }

    private void delegateConstructors(ClassWriterTracker ct, Class type, String superClassFileNname) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = type.getConstructors()) {
            Class<?>[] params = constructor.getParameterTypes();
            String[] exceptionTypes = AsmHelper.getInternalNames(constructor.getExceptionTypes());
            String descriptor = Type.getConstructorDescriptor(constructor);
            MethodVisitor mv = ct.visitMethod(1, "<init>", descriptor, null, exceptionTypes);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            int stackPos = 1;
            for (Class<?> param : params) {
                mv.visitVarInsn(AsmHelper.getLoadInsn(param), stackPos);
                stackPos += Type.getType(param).getSize();
            }
            mv.visitMethodInsn(183, superClassFileNname, "<init>", descriptor, false);
            mv.visitInsn(177);
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
        }
    }

    private void addProxyMethods(ClassWriterTracker ct, boolean defaultChangeTracker, String proxyClassDef, Class<?> parentClass) {
        MethodVisitor mv = ct.visitMethod(1, "setOwner", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(OpenJPAStateManager.class), Type.INT_TYPE}), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, proxyClassDef, "sm", Type.getDescriptor(OpenJPAStateManager.class));
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(21, 2);
        mv.visitFieldInsn(181, proxyClassDef, "field", Type.getDescriptor(Integer.TYPE));
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        mv = ct.visitMethod(1, "getOwner", Type.getMethodDescriptor((Type)Type.getType(OpenJPAStateManager.class), (Type[])new Type[0]), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, proxyClassDef, "sm", Type.getDescriptor(OpenJPAStateManager.class));
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        mv = ct.visitMethod(1, "getOwnerField", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, proxyClassDef, "field", Type.INT_TYPE.getDescriptor());
        mv.visitInsn(172);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        mv = ct.visitMethod(1, "clone", Type.getMethodDescriptor((Type)TYPE_OBJECT, (Type[])new Type[0]), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName(parentClass), "clone", Type.getMethodDescriptor((Type)TYPE_OBJECT, (Type[])new Type[0]), false);
        mv.visitTypeInsn(192, Type.getInternalName(Proxy.class));
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        mv.visitInsn(1);
        mv.visitInsn(3);
        mv.visitMethodInsn(185, Type.getInternalName(Proxy.class), "setOwner", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(OpenJPAStateManager.class), Type.INT_TYPE}), true);
        mv.visitVarInsn(25, 1);
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        if (defaultChangeTracker) {
            mv = ct.visitMethod(1, "getChangeTracker", Type.getMethodDescriptor((Type)Type.getType(ChangeTracker.class), (Type[])new Type[0]), null, null);
            mv.visitCode();
            mv.visitInsn(1);
            mv.visitInsn(176);
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
        }
    }

    private void addProxyDateMethods(ClassWriterTracker ct, String proxyClassDef, Class type) {
        Constructor cons;
        MethodVisitor mv;
        boolean hasDefaultCons = this.hasConstructor(type, new Class[0]);
        boolean hasMillisCons = this.hasConstructor(type, Long.TYPE);
        if (!hasDefaultCons && !hasMillisCons) {
            throw new UnsupportedException(_loc.get("no-date-cons", type));
        }
        if (!hasDefaultCons) {
            mv = ct.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, Type.getInternalName(System.class), "currentTimeMillis", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]), false);
            mv.visitMethodInsn(183, Type.getInternalName((Class)type), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.LONG_TYPE}), false);
            mv.visitInsn(177);
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
        }
        Class<Object>[] params = (cons = this.findCopyConstructor(type)) != null ? cons.getParameterTypes() : (hasMillisCons ? new Class[]{Long.TYPE} : new Class[]{});
        MethodVisitor mv2 = ct.visitMethod(1, "copy", Type.getMethodDescriptor((Type)TYPE_OBJECT, (Type[])new Type[]{TYPE_OBJECT}), null, null);
        mv2.visitCode();
        mv2.visitTypeInsn(187, Type.getInternalName((Class)type));
        mv2.visitInsn(89);
        if (params.length == 1) {
            mv2.visitVarInsn(25, 1);
            if (params[0] == Long.TYPE) {
                mv2.visitTypeInsn(192, Type.getInternalName(java.util.Date.class));
                mv2.visitMethodInsn(182, Type.getInternalName(java.util.Date.class), "getTime", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]), false);
            } else {
                mv2.visitTypeInsn(192, Type.getInternalName(params[0]));
            }
        }
        mv2.visitMethodInsn(183, Type.getInternalName((Class)type), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])AsmHelper.getParamTypes(params)), false);
        if (params.length == 0) {
            mv2.visitInsn(89);
            mv2.visitVarInsn(25, 1);
            mv2.visitTypeInsn(192, Type.getInternalName(java.util.Date.class));
            mv2.visitMethodInsn(182, Type.getInternalName(java.util.Date.class), "getTime", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]), false);
            mv2.visitMethodInsn(182, Type.getInternalName((Class)type), "setTime", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.LONG_TYPE}), false);
        }
        if ((params.length == 0 || params[0] == Long.TYPE) && Timestamp.class.isAssignableFrom(type)) {
            mv2.visitInsn(89);
            mv2.visitVarInsn(25, 1);
            mv2.visitTypeInsn(192, Type.getInternalName(Timestamp.class));
            mv2.visitMethodInsn(182, Type.getInternalName(Timestamp.class), "getNanos", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]), false);
            mv2.visitMethodInsn(182, Type.getInternalName((Class)type), "setNanos", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE}), false);
        }
        mv2.visitInsn(176);
        mv2.visitMaxs(-1, -1);
        mv2.visitEnd();
        mv = ct.visitMethod(1, "newInstance", Type.getMethodDescriptor((Type)Type.getType(ProxyDate.class), (Type[])new Type[0]), null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, proxyClassDef);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, proxyClassDef, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void addProxyCalendarMethods(ClassWriterTracker ct, String proxyClassDef, Class type) {
        Constructor cons = this.findCopyConstructor(type);
        Class[] params = cons == null ? new Class[]{} : cons.getParameterTypes();
        MethodVisitor mv = ct.visitMethod(1, "copy", Type.getMethodDescriptor((Type)TYPE_OBJECT, (Type[])new Type[]{TYPE_OBJECT}), null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, Type.getInternalName((Class)type));
        mv.visitInsn(89);
        mv.visitMethodInsn(183, Type.getInternalName((Class)type), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])AsmHelper.getParamTypes(params)), false);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, Type.getInternalName(Calendar.class));
        mv.visitMethodInsn(182, Type.getInternalName(Calendar.class), "getTimeInMillis", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]), false);
        mv.visitMethodInsn(182, Type.getInternalName((Class)type), "setTimeInMillis", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.LONG_TYPE}), false);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, Type.getInternalName(Calendar.class));
        mv.visitMethodInsn(182, Type.getInternalName(Calendar.class), "isLenient", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[0]), false);
        mv.visitMethodInsn(182, Type.getInternalName((Class)type), "setLenient", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.BOOLEAN_TYPE}), false);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, Type.getInternalName(Calendar.class));
        mv.visitMethodInsn(182, Type.getInternalName(Calendar.class), "getFirstDayOfWeek", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]), false);
        mv.visitMethodInsn(182, Type.getInternalName((Class)type), "setFirstDayOfWeek", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE}), false);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, Type.getInternalName(Calendar.class));
        mv.visitMethodInsn(182, Type.getInternalName(Calendar.class), "getMinimalDaysInFirstWeek", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]), false);
        mv.visitMethodInsn(182, Type.getInternalName((Class)type), "setMinimalDaysInFirstWeek", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE}), false);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, Type.getInternalName(Calendar.class));
        mv.visitMethodInsn(182, Type.getInternalName(Calendar.class), "getTimeZone", Type.getMethodDescriptor((Type)Type.getType(TimeZone.class), (Type[])new Type[0]), false);
        mv.visitMethodInsn(182, Type.getInternalName((Class)type), "setTimeZone", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(TimeZone.class)}), false);
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        MethodVisitor mv2 = ct.visitMethod(1, "newInstance", Type.getMethodDescriptor((Type)Type.getType(ProxyCalendar.class), (Type[])new Type[0]), null, null);
        mv2.visitCode();
        mv2.visitTypeInsn(187, proxyClassDef);
        mv2.visitInsn(89);
        mv2.visitMethodInsn(183, proxyClassDef, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        mv2.visitInsn(176);
        mv2.visitMaxs(-1, -1);
        mv2.visitEnd();
        mv2 = ct.visitMethod(4, "computeFields", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
        mv2.visitCode();
        mv2.visitVarInsn(25, 0);
        mv2.visitInsn(4);
        mv2.visitMethodInsn(184, Type.getInternalName(Proxies.class), "dirty", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Proxy.class), Type.BOOLEAN_TYPE}), false);
        mv2.visitVarInsn(25, 0);
        mv2.visitMethodInsn(183, Type.getInternalName((Class)type), "computeFields", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        mv2.visitInsn(177);
        mv2.visitMaxs(-1, -1);
        mv2.visitEnd();
    }

    private boolean proxySetters(ClassWriterTracker ct, String proxyClassDef, Class type) {
        Method[] meths = type.getMethods();
        int setters = 0;
        for (Method meth : meths) {
            if (!this.isSetter(meth) || Modifier.isFinal(meth.getModifiers())) continue;
            ++setters;
            this.proxySetter(ct, type, meth);
        }
        return setters > 0;
    }

    private void proxySetter(ClassWriterTracker ct, Class type, Method meth) {
        Class<?>[] params = meth.getParameterTypes();
        Class<?> ret = meth.getReturnType();
        String methodDescriptor = Type.getMethodDescriptor((Type)Type.getType(ret), (Type[])AsmHelper.getParamTypes(params));
        if (ct.hasMethod(meth.getName(), methodDescriptor)) {
            return;
        }
        MethodVisitor mv = ct.visitMethod(1, meth.getName(), methodDescriptor, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitInsn(4);
        mv.visitMethodInsn(184, Type.getInternalName(Proxies.class), "dirty", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Proxy.class), Type.BOOLEAN_TYPE}), false);
        mv.visitVarInsn(25, 0);
        int stackPos = 1;
        for (int i = 1; i <= params.length; ++i) {
            Class<?> param = params[i - 1];
            mv.visitVarInsn(AsmHelper.getLoadInsn(param), stackPos);
            stackPos += Type.getType(param).getSize();
        }
        mv.visitMethodInsn(183, Type.getInternalName((Class)type), meth.getName(), methodDescriptor, false);
        mv.visitInsn(AsmHelper.getReturnInsn(ret));
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void addWriteReplaceMethod(ClassWriterTracker ct, String proxyClassDef, boolean runtime) {
        MethodVisitor mv = ct.visitMethod(4, "writeReplace", Type.getMethodDescriptor((Type)TYPE_OBJECT, (Type[])new Type[0]), null, new String[]{Type.getInternalName(ObjectStreamException.class)});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitInsn(runtime ? 3 : 4);
        mv.visitMethodInsn(184, Type.getInternalName(Proxies.class), "writeReplace", Type.getMethodDescriptor((Type)TYPE_OBJECT, (Type[])new Type[]{Type.getType(Proxy.class), Type.BOOLEAN_TYPE}), false);
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private boolean hasConstructor(Class type, Class<?> ... paramTypes) {
        try {
            return type.getDeclaredConstructor(paramTypes) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    protected boolean allowsDuplicates(Class type) {
        return !Set.class.isAssignableFrom(type);
    }

    protected boolean isOrdered(Class type) {
        return List.class.isAssignableFrom(type) || "java.util.LinkedHashSet".equals(type.getName());
    }

    private static Class[] toHelperParameters(Class[] cls, Class helper) {
        Class[] params = new Class[cls.length + 1];
        params[0] = helper;
        System.arraycopy(cls, 0, params, 1, cls.length);
        return params;
    }

    private static Class[] toHelperAfterParameters(Class[] cls, Class ret, Class beforeRet) {
        if (ret == Void.TYPE && beforeRet == Void.TYPE) {
            return cls;
        }
        int len = cls.length;
        if (ret != Void.TYPE) {
            ++len;
        }
        if (beforeRet != Void.TYPE) {
            ++len;
        }
        Class[] params = new Class[len];
        System.arraycopy(cls, 0, params, 0, cls.length);
        int pos = cls.length;
        if (ret != Void.TYPE) {
            params[pos++] = ret;
        }
        if (beforeRet != Void.TYPE) {
            params[pos++] = beforeRet;
        }
        return params;
    }

    protected boolean isSetter(Method meth) {
        return ProxyManagerImpl.startsWith(meth.getName(), "set") || ProxyManagerImpl.startsWith(meth.getName(), "add") || ProxyManagerImpl.startsWith(meth.getName(), "remove") || ProxyManagerImpl.startsWith(meth.getName(), "insert") || ProxyManagerImpl.startsWith(meth.getName(), "clear") || ProxyManagerImpl.startsWith(meth.getName(), "roll");
    }

    protected Method findGetter(Class type, Method setter) {
        Method getter;
        String name = setter.getName().substring(3);
        Class<?> param = setter.getParameterTypes()[0];
        try {
            getter = type.getMethod("get" + name, null);
            if (getter.getReturnType().isAssignableFrom(param) || param.isAssignableFrom(getter.getReturnType())) {
                return getter;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception e) {
            throw new GeneralException(e);
        }
        if (param == Boolean.TYPE || param == Boolean.class) {
            try {
                getter = type.getMethod("is" + name, null);
                if (getter.getReturnType().isAssignableFrom(param) || param.isAssignableFrom(getter.getReturnType())) {
                    return getter;
                }
            }
            catch (NoSuchMethodException e) {
            }
            catch (Exception e) {
                throw new GeneralException(e);
            }
        }
        return null;
    }

    private static boolean startsWith(String str, String token) {
        return str.startsWith(token) && (str.length() == token.length() || Character.isUpperCase(str.charAt(token.length())));
    }

    private static synchronized long nextProxyId() {
        return _proxyId++;
    }

    protected Constructor findCopyConstructor(Class cls) {
        Constructor<?>[] cons = cls.getConstructors();
        Constructor<?> match = null;
        Class<?> matchParam = null;
        for (Constructor<?> con : cons) {
            Class<?>[] params = con.getParameterTypes();
            if (params.length != 1) continue;
            if (params[0] == cls) {
                return con;
            }
            if (!params[0].isAssignableFrom(cls) || matchParam != null && !matchParam.isAssignableFrom(params[0])) continue;
            match = con;
            matchParam = params[0];
        }
        return match;
    }

    private static Constructor findComparatorConstructor(Class cls) {
        try {
            return cls.getConstructor(Comparator.class);
        }
        catch (NoSuchMethodException nsme) {
            return null;
        }
        catch (Exception e) {
            throw new GeneralException(e);
        }
    }

    public static void main(String[] args) throws ClassNotFoundException, IOException {
        File dir = org.apache.openjpa.lib.util.Files.getClassFile(ProxyManagerImpl.class);
        dir = dir == null ? new File(AccessController.doPrivileged(J2DoPrivHelper.getPropertyAction("user.dir"))) : dir.getParentFile();
        Options opts = new Options();
        args = opts.setFromCmdLine(args);
        ArrayList<String> types = new ArrayList<String>(Arrays.asList(args));
        int utils = opts.removeIntProperty("utils", "u", 0);
        if (utils >= 4) {
            types.addAll(Arrays.asList(Date.class.getName(), Time.class.getName(), Timestamp.class.getName(), ArrayList.class.getName(), java.util.Date.class.getName(), GregorianCalendar.class.getName(), HashMap.class.getName(), HashSet.class.getName(), Hashtable.class.getName(), LinkedList.class.getName(), Properties.class.getName(), TreeMap.class.getName(), TreeSet.class.getName(), Vector.class.getName()));
        }
        if (utils >= 5) {
            types.addAll(Arrays.asList("java.util.EnumMap", "java.util.IdentityHashMap", "java.util.LinkedHashMap", "java.util.LinkedHashSet", "java.util.PriorityQueue"));
        }
        ProxyManagerImpl mgr = new ProxyManagerImpl();
        for (Object e : types) {
            Class<?> cls = Class.forName((String)e);
            try {
                if (Class.forName(ProxyManagerImpl.getProxyClassName(cls, false), true, GeneratedClasses.getMostDerivedLoader(cls, Proxy.class)) != null) {
                    continue;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            String proxyClassName = ProxyManagerImpl.getProxyClassName(cls, false);
            byte[] bytes = null;
            bytes = java.util.Date.class.isAssignableFrom(cls) ? mgr.generateProxyDateBytecode(cls, false, proxyClassName) : (Calendar.class.isAssignableFrom(cls) ? mgr.generateProxyCalendarBytecode(cls, false, proxyClassName) : (Collection.class.isAssignableFrom(cls) ? mgr.generateProxyCollectionBytecode(cls, false, proxyClassName) : (Map.class.isAssignableFrom(cls) ? mgr.generateProxyMapBytecode(cls, false, proxyClassName) : mgr.generateProxyBeanBytecode(cls, false, proxyClassName))));
            if (bytes == null) continue;
            String fileName = cls.getName().replace('.', '$') + "$proxy.class";
            Files.write(new File(dir, fileName).toPath(), bytes, new OpenOption[0]);
        }
    }

    static {
        _stdCollections.put(Collection.class, ArrayList.class);
        _stdCollections.put(Set.class, HashSet.class);
        _stdCollections.put(SortedSet.class, TreeSet.class);
        _stdCollections.put(List.class, ArrayList.class);
        _stdCollections.put(Queue.class, LinkedList.class);
        _stdMaps.put(Map.class, HashMap.class);
        _stdMaps.put(SortedMap.class, TreeMap.class);
    }
}

