/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.index.tree;

import java.util.Arrays;

abstract class PointTreeNode
implements Cloneable {
    PointTreeNode() {
    }

    static int quadrant(double[] point, double[] region) {
        int q = 0;
        int i = region.length >>> 1;
        while (--i >= 0) {
            if (!(point[i] < region[i])) continue;
            q |= 1 << i;
        }
        return q;
    }

    static void enterQuadrant(double[] region, int quadrant) {
        int n;
        int i = n = region.length >>> 1;
        while (--i >= 0) {
            int n2 = i + n;
            double d = region[n2] * 0.5;
            region[n2] = d;
            region[i] = Math.fma(PointTreeNode.factor(quadrant, i), d, region[i]);
        }
    }

    static double factor(int quadrant, int dimension) {
        return Double.longBitsToDouble(0x3FE0000000000000L | (long)(quadrant & 1 << dimension) << 63 - dimension);
    }

    abstract void clear();

    abstract Object getChild(int var1);

    abstract void setChild(int var1, Object var2);

    abstract PointTreeNode newInstance();

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    static final class Default
    extends PointTreeNode {
        private final Object[] children;

        Default(int n) {
            this.children = new Object[n];
        }

        private Default(Default other) {
            this.children = (Object[])other.children.clone();
            for (int i = 0; i < this.children.length; ++i) {
                Object value = this.children[i];
                if (!(value instanceof PointTreeNode)) continue;
                this.children[i] = ((PointTreeNode)value).clone();
            }
        }

        @Override
        final PointTreeNode newInstance() {
            return new Default(this.children.length);
        }

        @Override
        final void clear() {
            Arrays.fill(this.children, null);
        }

        @Override
        final Object getChild(int quadrant) {
            return this.children[quadrant];
        }

        @Override
        final void setChild(int quadrant, Object child) {
            this.children[quadrant] = child;
        }

        @Override
        protected Object clone() {
            return new Default(this);
        }
    }
}

