/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.uuid.impl;

import com.fasterxml.uuid.UUIDTimer;
import com.fasterxml.uuid.UUIDType;
import java.util.UUID;

public class UUIDUtil {
    public static final int BYTE_OFFSET_CLOCK_LO = 0;
    public static final int BYTE_OFFSET_CLOCK_MID = 4;
    public static final int BYTE_OFFSET_CLOCK_HI = 6;
    public static final int BYTE_OFFSET_TYPE = 6;
    public static final int BYTE_OFFSET_CLOCK_SEQUENCE = 8;
    public static final int BYTE_OFFSET_VARIATION = 8;
    private static final UUID NIL_UUID = new UUID(0L, 0L);
    private static final UUID MAX_UUID = new UUID(-1L, -1L);

    public static UUID nilUUID() {
        return NIL_UUID;
    }

    public static UUID maxUUID() {
        return MAX_UUID;
    }

    public static UUID uuid(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        if (id.length() != 36) {
            throw new NumberFormatException("UUID has to be represented by the standard 36-char representation");
        }
        long hi = 0L;
        long lo = 0L;
        int i = 0;
        int j = 0;
        while (i < 36) {
            int curr;
            switch (i) {
                case 8: 
                case 13: 
                case 18: 
                case 23: {
                    if (id.charAt(i) != '-') {
                        throw new NumberFormatException("UUID has to be represented by the standard 36-char representation");
                    }
                    ++i;
                }
            }
            char c = id.charAt(i);
            if (c >= '0' && c <= '9') {
                curr = c - 48;
            } else if (c >= 'a' && c <= 'f') {
                curr = c - 97 + 10;
            } else if (c >= 'A' && c <= 'F') {
                curr = c - 65 + 10;
            } else {
                throw new NumberFormatException("Non-hex character at #" + i + ": '" + c + "' (value 0x" + Integer.toHexString(c) + ")");
            }
            curr <<= 4;
            c = id.charAt(++i);
            if (c >= '0' && c <= '9') {
                curr |= c - 48;
            } else if (c >= 'a' && c <= 'f') {
                curr |= c - 97 + 10;
            } else if (c >= 'A' && c <= 'F') {
                curr |= c - 65 + 10;
            } else {
                throw new NumberFormatException("Non-hex character at #" + i + ": '" + c + "' (value 0x" + Integer.toHexString(c) + ")");
            }
            if (j < 8) {
                hi = hi << 8 | (long)curr;
            } else {
                lo = lo << 8 | (long)curr;
            }
            ++i;
            ++j;
        }
        return new UUID(hi, lo);
    }

    public static UUID uuid(byte[] bytes) {
        UUIDUtil._checkUUIDByteArray(bytes, 0);
        long l1 = UUIDUtil.gatherLong(bytes, 0);
        long l2 = UUIDUtil.gatherLong(bytes, 8);
        return new UUID(l1, l2);
    }

    public static UUID uuid(byte[] bytes, int offset) {
        UUIDUtil._checkUUIDByteArray(bytes, offset);
        return new UUID(UUIDUtil.gatherLong(bytes, offset), UUIDUtil.gatherLong(bytes, offset + 8));
    }

    public static UUID constructUUID(UUIDType type, byte[] uuidBytes) {
        int b = uuidBytes[6] & 0xF;
        uuidBytes[6] = (byte)(b |= type.raw() << 4);
        b = uuidBytes[8] & 0x3F;
        uuidBytes[8] = (byte)(b |= 0x80);
        return UUIDUtil.uuid(uuidBytes);
    }

    public static UUID constructUUID(UUIDType type, long l1, long l2) {
        l1 &= 0xFFFFFFFFFFFF0FFFL;
        l2 = l2 << 2 >>> 2;
        return new UUID(l1 |= (long)(type.raw() << 12), l2 |= Long.MIN_VALUE);
    }

    public static long initUUIDFirstLong(long l1, UUIDType type) {
        return UUIDUtil.initUUIDFirstLong(l1, type.raw());
    }

    public static long initUUIDFirstLong(long l1, int rawType) {
        l1 &= 0xFFFFFFFFFFFF0FFFL;
        return l1 |= (long)(rawType << 12);
    }

    public static long initUUIDSecondLong(long l2) {
        l2 = l2 << 2 >>> 2;
        return l2 |= Long.MIN_VALUE;
    }

    public static UUIDType typeOf(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        long l = uuid.getMostSignificantBits();
        int typeNibble = (int)l >> 12 & 0xF;
        switch (typeNibble) {
            case 0: {
                if (l != 0L || uuid.getLeastSignificantBits() != l) break;
                return UUIDType.UNKNOWN;
            }
            case 1: {
                return UUIDType.TIME_BASED;
            }
            case 2: {
                return UUIDType.DCE;
            }
            case 3: {
                return UUIDType.NAME_BASED_MD5;
            }
            case 4: {
                return UUIDType.RANDOM_BASED;
            }
            case 5: {
                return UUIDType.NAME_BASED_SHA1;
            }
            case 6: {
                return UUIDType.TIME_BASED_REORDERED;
            }
            case 7: {
                return UUIDType.TIME_BASED_EPOCH;
            }
            case 8: {
                return UUIDType.FREE_FORM;
            }
        }
        return null;
    }

    public static byte[] asByteArray(UUID uuid) {
        long hi = uuid.getMostSignificantBits();
        long lo = uuid.getLeastSignificantBits();
        byte[] result = new byte[16];
        UUIDUtil._appendInt((int)(hi >> 32), result, 0);
        UUIDUtil._appendInt((int)hi, result, 4);
        UUIDUtil._appendInt((int)(lo >> 32), result, 8);
        UUIDUtil._appendInt((int)lo, result, 12);
        return result;
    }

    public static void toByteArray(UUID uuid, byte[] buffer) {
        UUIDUtil.toByteArray(uuid, buffer, 0);
    }

    public static void toByteArray(UUID uuid, byte[] buffer, int offset) {
        UUIDUtil._checkUUIDByteArray(buffer, offset);
        long hi = uuid.getMostSignificantBits();
        long lo = uuid.getLeastSignificantBits();
        UUIDUtil._appendInt((int)(hi >> 32), buffer, offset);
        UUIDUtil._appendInt((int)hi, buffer, offset + 4);
        UUIDUtil._appendInt((int)(lo >> 32), buffer, offset + 8);
        UUIDUtil._appendInt((int)lo, buffer, offset + 12);
    }

    protected static final long gatherLong(byte[] buffer, int offset) {
        long hi = (long)UUIDUtil._gatherInt(buffer, offset) << 32;
        long lo = (long)UUIDUtil._gatherInt(buffer, offset + 4) << 32 >>> 32;
        return hi | lo;
    }

    private static final void _appendInt(int value, byte[] buffer, int offset) {
        buffer[offset++] = (byte)(value >> 24);
        buffer[offset++] = (byte)(value >> 16);
        buffer[offset++] = (byte)(value >> 8);
        buffer[offset] = (byte)value;
    }

    private static final int _gatherInt(byte[] buffer, int offset) {
        return buffer[offset] << 24 | (buffer[offset + 1] & 0xFF) << 16 | (buffer[offset + 2] & 0xFF) << 8 | buffer[offset + 3] & 0xFF;
    }

    private static final void _checkUUIDByteArray(byte[] bytes, int offset) {
        if (bytes == null) {
            throw new IllegalArgumentException("Invalid byte[] passed: can not be null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Invalid offset (" + offset + ") passed: can not be negative");
        }
        if (offset + 16 > bytes.length) {
            throw new IllegalArgumentException("Invalid offset (" + offset + ") passed: not enough room in byte array (need 16 bytes)");
        }
    }

    public static long extractTimestamp(UUID uuid) {
        UUIDType type = UUIDUtil.typeOf(uuid);
        if (type == null) {
            return 0L;
        }
        switch (type) {
            case NAME_BASED_SHA1: 
            case UNKNOWN: 
            case DCE: 
            case RANDOM_BASED: 
            case FREE_FORM: 
            case NAME_BASED_MD5: {
                return 0L;
            }
            case TIME_BASED: {
                return UUIDTimer.timestampToEpoch(UUIDUtil._getRawTimestampFromUuidV1(uuid));
            }
            case TIME_BASED_REORDERED: {
                return UUIDTimer.timestampToEpoch(UUIDUtil._getRawTimestampFromUuidV6(uuid));
            }
            case TIME_BASED_EPOCH: {
                return UUIDUtil._getRawTimestampFromUuidV7(uuid);
            }
        }
        throw new IllegalArgumentException("Invalid `UUID`: unexpected type " + (Object)((Object)type));
    }

    static long _getRawTimestampFromUuidV1(UUID uuid) {
        long mostSignificantBits = uuid.getMostSignificantBits();
        long low = (mostSignificantBits &= 0xFFFFFFFFFFFFEFFFL) >>> 32;
        long lowOfHigher = mostSignificantBits & 0xFFFF0000L;
        long highOfHigher = mostSignificantBits & 0xFFFFL;
        return highOfHigher << 48 | (lowOfHigher >>>= 16) << 32 | low;
    }

    static long _getRawTimestampFromUuidV6(UUID uuid) {
        long mostSignificantBits = uuid.getMostSignificantBits();
        long lowL = (mostSignificantBits &= 0xFFFFFFFFFFFF9FFFL) & 0xFFFL;
        long lowH = mostSignificantBits & 0xFFFF0000L;
        long high = mostSignificantBits & 0xFFFFFFFF00000000L;
        return high >>> 4 | (lowH >>>= 16) << 12 | lowL;
    }

    static long _getRawTimestampFromUuidV7(UUID uuid) {
        long mostSignificantBits = uuid.getMostSignificantBits();
        return (mostSignificantBits &= 0xFFFFFFFFFFFF9FFFL) >>> 16;
    }
}

