/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.jetty.websocket.client;

import com.signalfx.shaded.jetty.client.HttpClient;
import com.signalfx.shaded.jetty.io.ByteBufferPool;
import com.signalfx.shaded.jetty.io.MappedByteBufferPool;
import com.signalfx.shaded.jetty.util.ssl.SslContextFactory;
import com.signalfx.shaded.jetty.util.thread.QueuedThreadPool;
import com.signalfx.shaded.jetty.websocket.common.scopes.WebSocketContainerScope;
import java.util.concurrent.Executor;

class DefaultHttpClientProvider {
    DefaultHttpClientProvider() {
    }

    public static HttpClient newHttpClient(WebSocketContainerScope scope) {
        SslContextFactory sslContextFactory = null;
        Executor executor = null;
        ByteBufferPool bufferPool = null;
        if (scope != null) {
            sslContextFactory = scope.getSslContextFactory();
            executor = scope.getExecutor();
            bufferPool = scope.getBufferPool();
        }
        if (sslContextFactory == null) {
            sslContextFactory = new SslContextFactory.Client();
            sslContextFactory.setTrustAll(false);
            sslContextFactory.setEndpointIdentificationAlgorithm("HTTPS");
        }
        HttpClient client = new HttpClient(sslContextFactory);
        if (executor == null) {
            QueuedThreadPool threadPool = new QueuedThreadPool();
            String name = "WebSocketClient@" + client.hashCode();
            threadPool.setName(name);
            threadPool.setDaemon(true);
            executor = threadPool;
        }
        client.setExecutor(executor);
        if (bufferPool == null) {
            bufferPool = new MappedByteBufferPool();
        }
        client.setByteBufferPool(bufferPool);
        return client;
    }
}

