/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.pages;

import de.agilecoders.wicket.core.markup.html.bootstrap.tabs.AjaxBootstrapTabbedPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.client.console.BookmarkablePageLinkBuilder;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.pages.Dashboard;
import org.apache.syncope.client.console.panels.AMSessionPanel;
import org.apache.syncope.client.console.panels.SRARouteDirectoryPanel;
import org.apache.syncope.client.console.panels.SRAStatisticsPanel;
import org.apache.syncope.client.console.rest.SRARouteRestClient;
import org.apache.syncope.client.console.rest.SRASessionRestClient;
import org.apache.syncope.client.ui.commons.annotations.AMPage;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;

@AMPage(label="SRA", icon="fas fa-share-alt", listEntitlement="", priority=100)
public class SRA
extends BasePage {
    private static final long serialVersionUID = 9200112197134882164L;
    @SpringBean
    private SRARouteRestClient sraRouteRestClient;
    @SpringBean
    private ServiceOps serviceOps;

    public SRA(PageParameters parameters) {
        super(parameters);
        this.body.add(new Component[]{BookmarkablePageLinkBuilder.build((String)"dashboard", (String)"dashboardBr", Dashboard.class)});
        this.body.setOutputMarkupId(true);
        List instances = this.serviceOps.list(NetworkService.Type.SRA);
        AjaxLink<Object> push = new AjaxLink<Object>("push"){
            private static final long serialVersionUID = -817438685948164787L;

            public void onClick(AjaxRequestTarget target) {
                try {
                    SRA.this.sraRouteRestClient.push();
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                }
                catch (Exception e) {
                    LOG.error("While pushing to SRA", (Throwable)e);
                    SyncopeConsoleSession.get().onException(e);
                }
                ((BasePage)SRA.this.getPageReference().getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        };
        push.setEnabled(!instances.isEmpty() && SyncopeConsoleSession.get().owns("SRA_ROUTE_PUSH", new String[0]));
        this.body.add(new Component[]{push});
        WebMarkupContainer content = new WebMarkupContainer("content");
        this.body.add(new Component[]{content.setOutputMarkupId(true)});
        content.add(new Component[]{new AjaxBootstrapTabbedPanel("tabbedPanel", this.buildTabList(instances))});
    }

    private List<ITab> buildTabList(final List<NetworkService> instances) {
        ArrayList<ITab> tabs = new ArrayList<ITab>();
        tabs.add((ITab)new AbstractTab((IModel)new ResourceModel("routes")){
            private static final long serialVersionUID = 5211692813425391144L;

            public Panel getPanel(String panelId) {
                return new SRARouteDirectoryPanel(panelId, SRA.this.sraRouteRestClient, SRA.this.getPageReference());
            }
        });
        if (!instances.isEmpty()) {
            tabs.add((ITab)new AbstractTab((IModel)new ResourceModel("metrics")){
                private static final long serialVersionUID = 5211692813425391144L;

                public Panel getPanel(String panelId) {
                    return new SRAStatisticsPanel(panelId, instances);
                }
            });
        }
        if (!instances.isEmpty() && SyncopeConsoleSession.get().owns("SRA_SESSION_LIST", new String[0])) {
            tabs.add((ITab)new AbstractTab((IModel)new ResourceModel("sessions")){
                private static final long serialVersionUID = 5211692813425391144L;

                public Panel getPanel(String panelId) {
                    return new AMSessionPanel(panelId, new SRASessionRestClient(instances), "SRA_SESSION_LIST", "SRA_SESSION_DELETE", SRA.this.getPageReference());
                }
            });
        }
        return tabs;
    }
}

