/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.endpoint.Access;
import org.springframework.boot.actuate.endpoint.EndpointAccessResolver;
import org.springframework.boot.actuate.endpoint.web.EndpointServlet;
import org.springframework.boot.actuate.endpoint.web.ExposableServletEndpoint;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Deprecated(since="3.3.0", forRemoval=true)
public class ServletEndpointRegistrar
implements ServletContextInitializer {
    private static final Set<String> READ_ONLY_ACCESS_REQUEST_METHODS = Set.of("GET", "HEAD");
    private static final Log logger = LogFactory.getLog(ServletEndpointRegistrar.class);
    private final String basePath;
    private final Collection<ExposableServletEndpoint> servletEndpoints;
    private final EndpointAccessResolver endpointAccessResolver;

    public ServletEndpointRegistrar(String basePath, Collection<ExposableServletEndpoint> servletEndpoints) {
        this(basePath, servletEndpoints, (endpointId, defaultAccess) -> Access.NONE);
    }

    public ServletEndpointRegistrar(String basePath, Collection<ExposableServletEndpoint> servletEndpoints, EndpointAccessResolver endpointAccessResolver) {
        Assert.notNull(servletEndpoints, (String)"ServletEndpoints must not be null");
        this.basePath = ServletEndpointRegistrar.cleanBasePath(basePath);
        this.servletEndpoints = servletEndpoints;
        this.endpointAccessResolver = endpointAccessResolver;
    }

    private static String cleanBasePath(String basePath) {
        if (StringUtils.hasText((String)basePath) && basePath.endsWith("/")) {
            return basePath.substring(0, basePath.length() - 1);
        }
        return basePath != null ? basePath : "";
    }

    public void onStartup(ServletContext servletContext) throws ServletException {
        this.servletEndpoints.forEach(servletEndpoint -> this.register(servletContext, (ExposableServletEndpoint)servletEndpoint));
    }

    private void register(ServletContext servletContext, ExposableServletEndpoint endpoint) {
        Access access = this.endpointAccessResolver.accessFor(endpoint.getEndpointId(), endpoint.getDefaultAccess());
        if (access == Access.NONE) {
            return;
        }
        String name = endpoint.getEndpointId().toLowerCaseString() + "-actuator-endpoint";
        String path = this.basePath + "/" + endpoint.getRootPath();
        String urlMapping = path.endsWith("/") ? path + "*" : path + "/*";
        EndpointServlet endpointServlet = endpoint.getEndpointServlet();
        ServletRegistration.Dynamic registration = servletContext.addServlet(name, endpointServlet.getServlet());
        registration.addMapping(new String[]{urlMapping});
        registration.setInitParameters(endpointServlet.getInitParameters());
        registration.setLoadOnStartup(endpointServlet.getLoadOnStartup());
        if (access == Access.READ_ONLY) {
            servletContext.addFilter(name + "-access-filter", (Filter)new ReadOnlyAccessFilter()).addMappingForServletNames(EnumSet.allOf(DispatcherType.class), false, new String[]{name});
        }
        logger.info((Object)("Registered '" + path + "' to " + name));
    }

    static class ReadOnlyAccessFilter
    implements Filter {
        private static final int METHOD_NOT_ALLOWED = 405;

        ReadOnlyAccessFilter() {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            HttpServletRequest httpRequest;
            block3: {
                block2: {
                    if (!(request instanceof HttpServletRequest)) break block2;
                    httpRequest = (HttpServletRequest)request;
                    if (response instanceof HttpServletResponse) break block3;
                }
                throw new ServletException();
            }
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            this.doFilter(httpRequest, httpResponse, chain);
        }

        private void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
            if (this.isReadOnlyAccessMethod(request)) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                response.sendError(405);
            }
        }

        private boolean isReadOnlyAccessMethod(HttpServletRequest request) {
            return READ_ONLY_ACCESS_REQUEST_METHODS.contains(request.getMethod().toUpperCase(Locale.ROOT));
        }
    }
}

