/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.PassphraseEncryptionCipherType;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class PassphraseEncryptedOutputStreamProperties
implements Serializable {
    private static final long serialVersionUID = 2778471308512283705L;
    private boolean writeHeaderToStream;
    private int keyFactoryIterationCount;
    @NotNull
    private final PassphraseEncryptionCipherType cipherType;
    @Nullable
    private String keyIdentifier;

    public PassphraseEncryptedOutputStreamProperties(@NotNull PassphraseEncryptionCipherType cipherType) {
        this.cipherType = cipherType;
        this.writeHeaderToStream = true;
        this.keyFactoryIterationCount = cipherType.getKeyFactoryIterationCount();
        this.keyIdentifier = null;
    }

    @NotNull
    public PassphraseEncryptionCipherType getCipherType() {
        return this.cipherType;
    }

    public boolean writeHeaderToStream() {
        return this.writeHeaderToStream;
    }

    public void setWriteHeaderToStream(boolean writeHeaderToStream) {
        this.writeHeaderToStream = writeHeaderToStream;
    }

    public int getKeyFactoryIterationCount() {
        return this.keyFactoryIterationCount;
    }

    public void setKeyFactoryIterationCount(@Nullable Integer keyFactoryIterationCount) {
        this.keyFactoryIterationCount = keyFactoryIterationCount == null ? this.cipherType.getKeyFactoryIterationCount() : keyFactoryIterationCount.intValue();
    }

    @Nullable
    public String getKeyIdentifier() {
        return this.keyIdentifier;
    }

    public void setKeyIdentifier(@Nullable String keyIdentifier) {
        this.keyIdentifier = keyIdentifier;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("PassphraseEncryptedOutputStreamProperties(cipherType=");
        this.cipherType.toString(buffer);
        buffer.append(", writeHeaderToStream=");
        buffer.append(this.writeHeaderToStream);
        if (this.keyFactoryIterationCount != this.cipherType.getKeyFactoryIterationCount()) {
            buffer.append(", keyFactoryIterationCount=");
            buffer.append(this.keyFactoryIterationCount);
        }
        if (this.keyIdentifier != null) {
            buffer.append(", keyIdentifier='");
            buffer.append(this.keyIdentifier);
            buffer.append('\'');
        }
        buffer.append(')');
    }
}

