/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.parser;

import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlOperator;
import org.apache.commons.jexl3.internal.ScriptVisitor;
import org.apache.commons.jexl3.parser.ASTAddNode;
import org.apache.commons.jexl3.parser.ASTBitwiseAndNode;
import org.apache.commons.jexl3.parser.ASTBitwiseComplNode;
import org.apache.commons.jexl3.parser.ASTBitwiseOrNode;
import org.apache.commons.jexl3.parser.ASTBitwiseXorNode;
import org.apache.commons.jexl3.parser.ASTDivNode;
import org.apache.commons.jexl3.parser.ASTEQNode;
import org.apache.commons.jexl3.parser.ASTEQSNode;
import org.apache.commons.jexl3.parser.ASTERNode;
import org.apache.commons.jexl3.parser.ASTEWNode;
import org.apache.commons.jexl3.parser.ASTGENode;
import org.apache.commons.jexl3.parser.ASTGTNode;
import org.apache.commons.jexl3.parser.ASTLENode;
import org.apache.commons.jexl3.parser.ASTLTNode;
import org.apache.commons.jexl3.parser.ASTModNode;
import org.apache.commons.jexl3.parser.ASTMulNode;
import org.apache.commons.jexl3.parser.ASTNENode;
import org.apache.commons.jexl3.parser.ASTNESNode;
import org.apache.commons.jexl3.parser.ASTNEWNode;
import org.apache.commons.jexl3.parser.ASTNRNode;
import org.apache.commons.jexl3.parser.ASTNSWNode;
import org.apache.commons.jexl3.parser.ASTNotNode;
import org.apache.commons.jexl3.parser.ASTSWNode;
import org.apache.commons.jexl3.parser.ASTSetAddNode;
import org.apache.commons.jexl3.parser.ASTSetAndNode;
import org.apache.commons.jexl3.parser.ASTSetDivNode;
import org.apache.commons.jexl3.parser.ASTSetModNode;
import org.apache.commons.jexl3.parser.ASTSetMultNode;
import org.apache.commons.jexl3.parser.ASTSetOrNode;
import org.apache.commons.jexl3.parser.ASTSetSubNode;
import org.apache.commons.jexl3.parser.ASTSetXorNode;
import org.apache.commons.jexl3.parser.ASTSubNode;
import org.apache.commons.jexl3.parser.JexlNode;

final class OperatorController
extends ScriptVisitor {
    static final OperatorController INSTANCE = new OperatorController();

    OperatorController() {
    }

    boolean isStrict(JexlArithmetic arithmetic, JexlNode node) {
        Object ctl;
        if (arithmetic.isStrict() && (ctl = node.jjtAccept(this, arithmetic)) instanceof JexlOperator) {
            JexlOperator operator = (JexlOperator)((Object)ctl);
            return arithmetic.isStrict(operator);
        }
        return false;
    }

    protected JexlOperator visit(ASTAddNode node, Object data) {
        return JexlOperator.ADD;
    }

    protected JexlOperator visit(ASTBitwiseAndNode node, Object data) {
        return JexlOperator.AND;
    }

    protected JexlOperator visit(ASTBitwiseComplNode node, Object data) {
        return JexlOperator.COMPLEMENT;
    }

    protected JexlOperator visit(ASTBitwiseOrNode node, Object data) {
        return JexlOperator.OR;
    }

    protected JexlOperator visit(ASTBitwiseXorNode node, Object data) {
        return JexlOperator.XOR;
    }

    protected JexlOperator visit(ASTDivNode node, Object data) {
        return JexlOperator.DIVIDE;
    }

    protected JexlOperator visit(ASTEQNode node, Object data) {
        return JexlOperator.EQ;
    }

    protected JexlOperator visit(ASTEQSNode node, Object data) {
        return JexlOperator.EQSTRICT;
    }

    protected JexlOperator visit(ASTERNode node, Object data) {
        return JexlOperator.CONTAINS;
    }

    protected JexlOperator visit(ASTEWNode node, Object data) {
        return JexlOperator.ENDSWITH;
    }

    protected JexlOperator visit(ASTGENode node, Object data) {
        return JexlOperator.GTE;
    }

    protected JexlOperator visit(ASTGTNode node, Object data) {
        return JexlOperator.GT;
    }

    protected JexlOperator visit(ASTLENode node, Object data) {
        return JexlOperator.LTE;
    }

    protected JexlOperator visit(ASTLTNode node, Object data) {
        return JexlOperator.LT;
    }

    protected JexlOperator visit(ASTModNode node, Object data) {
        return JexlOperator.MOD;
    }

    protected JexlOperator visit(ASTMulNode node, Object data) {
        return JexlOperator.MULTIPLY;
    }

    protected JexlOperator visit(ASTNENode node, Object data) {
        return JexlOperator.EQ;
    }

    protected JexlOperator visit(ASTNESNode node, Object data) {
        return JexlOperator.EQSTRICT;
    }

    protected JexlOperator visit(ASTNEWNode node, Object data) {
        return JexlOperator.ENDSWITH;
    }

    protected JexlOperator visit(ASTNotNode node, Object data) {
        return JexlOperator.NOT;
    }

    protected JexlOperator visit(ASTNRNode node, Object data) {
        return JexlOperator.CONTAINS;
    }

    protected JexlOperator visit(ASTNSWNode node, Object data) {
        return JexlOperator.STARTSWITH;
    }

    protected JexlOperator visit(ASTSetAddNode node, Object data) {
        return JexlOperator.SELF_ADD;
    }

    protected JexlOperator visit(ASTSetAndNode node, Object data) {
        return JexlOperator.SELF_AND;
    }

    protected JexlOperator visit(ASTSetDivNode node, Object data) {
        return JexlOperator.SELF_DIVIDE;
    }

    protected JexlOperator visit(ASTSetModNode node, Object data) {
        return JexlOperator.SELF_MOD;
    }

    protected JexlOperator visit(ASTSetMultNode node, Object data) {
        return JexlOperator.SELF_MULTIPLY;
    }

    protected JexlOperator visit(ASTSetOrNode node, Object data) {
        return JexlOperator.SELF_OR;
    }

    protected JexlOperator visit(ASTSetSubNode node, Object data) {
        return JexlOperator.SELF_SUBTRACT;
    }

    protected JexlOperator visit(ASTSetXorNode node, Object data) {
        return JexlOperator.SELF_OR;
    }

    protected JexlOperator visit(ASTSubNode node, Object data) {
        return JexlOperator.SUBTRACT;
    }

    protected JexlOperator visit(ASTSWNode node, Object data) {
        return JexlOperator.STARTSWITH;
    }

    protected JexlOperator visitNode(JexlNode node, Object data) {
        return null;
    }
}

