/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.credentials.authenticator;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.client.authentication.AttributePrincipal;
import org.apereo.cas.client.validation.Assertion;
import org.apereo.cas.client.validation.TicketValidationException;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.profile.CasProfileDefinition;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.http.callback.CallbackUrlResolver;
import org.pac4j.core.http.url.UrlResolver;
import org.pac4j.core.logout.handler.SessionLogoutHandler;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.definition.ProfileDefinition;
import org.pac4j.core.profile.definition.ProfileDefinitionAware;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasAuthenticator
extends ProfileDefinitionAware
implements Authenticator {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasAuthenticator.class);
    protected CasConfiguration configuration;
    protected String clientName;
    protected UrlResolver urlResolver;
    protected CallbackUrlResolver callbackUrlResolver;
    protected String callbackUrl;
    protected SessionLogoutHandler sessionLogoutHandler;

    public CasAuthenticator(CasConfiguration configuration, String clientName, UrlResolver urlResolver, CallbackUrlResolver callbackUrlResolver, String callbackUrl, SessionLogoutHandler sessionLogoutHandler) {
        this.configuration = configuration;
        this.clientName = clientName;
        this.urlResolver = urlResolver;
        this.callbackUrlResolver = callbackUrlResolver;
        this.callbackUrl = callbackUrl;
        this.sessionLogoutHandler = sessionLogoutHandler;
    }

    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertNotNull((String)"urlResolver", (Object)this.urlResolver);
        CommonHelper.assertNotNull((String)"callbackUrlResolver", (Object)this.callbackUrlResolver);
        CommonHelper.assertNotBlank((String)"clientName", (String)this.clientName);
        CommonHelper.assertNotBlank((String)"callbackUrl", (String)this.callbackUrl);
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        this.setProfileDefinitionIfUndefined((ProfileDefinition)new CasProfileDefinition());
    }

    public Optional<Credentials> validate(CallContext ctx, Credentials cred) {
        if (cred instanceof TokenCredentials) {
            TokenCredentials credentials = (TokenCredentials)cred;
            this.init();
            WebContext webContext = ctx.webContext();
            String ticket = credentials.getToken();
            try {
                Assertion assertion = this.validateTicket(webContext, ticket);
                this.recordSession(ctx, ticket);
                AttributePrincipal principal = assertion.getPrincipal();
                LOGGER.debug("principal: {}", (Object)principal);
                UserProfile profile = this.createUserProfile(principal);
                this.createUserProfileAttributes(assertion, principal, profile);
                LOGGER.debug("profile returned by CAS: {}", (Object)profile);
                credentials.setUserProfile(profile);
            }
            catch (TicketValidationException e) {
                String message = "cannot validate CAS ticket: " + ticket;
                throw new TechnicalException(message, (Throwable)e);
            }
        }
        return Optional.ofNullable(cred);
    }

    protected void recordSession(CallContext ctx, String ticket) {
        if (this.sessionLogoutHandler != null) {
            this.sessionLogoutHandler.recordSession(ctx, ticket);
        }
    }

    protected void createUserProfileAttributes(Assertion assertion, AttributePrincipal principal, UserProfile profile) {
        HashMap newPrincipalAttributes = new HashMap();
        HashMap newAuthenticationAttributes = new HashMap();
        Map oldPrincipalAttributes = principal.getAttributes();
        Map oldAuthenticationAttributes = assertion.getAttributes();
        if (oldPrincipalAttributes != null) {
            newPrincipalAttributes.putAll(oldPrincipalAttributes);
        }
        if (oldAuthenticationAttributes != null) {
            newAuthenticationAttributes.putAll(oldAuthenticationAttributes);
        }
        this.getProfileDefinition().convertAndAdd(profile, newPrincipalAttributes, newAuthenticationAttributes);
    }

    protected UserProfile createUserProfile(AttributePrincipal principal) {
        String id = principal.getName();
        UserProfile profile = this.getProfileDefinition().newProfile(new Object[]{id, this.configuration.getProxyReceptor(), principal});
        profile.setId(ProfileHelper.sanitizeIdentifier((Object)id));
        return profile;
    }

    protected Assertion validateTicket(WebContext webContext, String ticket) throws TicketValidationException {
        String finalCallbackUrl = this.callbackUrlResolver.compute(this.urlResolver, this.callbackUrl, this.clientName, webContext);
        return this.configuration.retrieveTicketValidator(webContext).validate(ticket, finalCallbackUrl);
    }
}

