/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.to.ConnObject;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;

public class ConnObjectAttrColumn
extends AbstractColumn<ConnObject, String> {
    private static final long serialVersionUID = 2624734332447371372L;
    private final String name;

    public ConnObjectAttrColumn(String name, SchemaType schemaType) {
        super((IModel)new ResourceModel(name, name), (Object)(schemaType.name() + "#" + name));
        this.name = name;
    }

    public void populateItem(Item<ICellPopulator<ConnObject>> cellItem, String componentId, IModel<ConnObject> rowModel) {
        Optional attr = ((ConnObject)rowModel.getObject()).getAttr(this.name);
        List values = attr.map(Attr::getValues).orElse(null);
        if (values == null || values.isEmpty()) {
            cellItem.add(new Component[]{new Label(componentId, (Serializable)((Object)""))});
        } else if (values.size() == 1) {
            cellItem.add(new Component[]{new Label(componentId, (Serializable)values.getFirst())});
        } else {
            cellItem.add(new Component[]{new Label(componentId, (Serializable)((Object)values.toString()))});
        }
    }
}

