/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.actuate.autoconfigure.endpoint.PropertiesEndpointAccessResolver;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.EndpointExposureOutcomeContributor;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.EndpointExposure;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.IncludeExcludeEndpointFilter;
import org.springframework.boot.actuate.endpoint.Access;
import org.springframework.boot.actuate.endpoint.EndpointAccessResolver;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.actuate.endpoint.ExposableEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.EndpointExtension;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;

class OnAvailableEndpointCondition
extends SpringBootCondition {
    private static final String JMX_ENABLED_KEY = "spring.jmx.enabled";
    private static final Map<Environment, EndpointAccessResolver> accessResolversCache = new ConcurrentReferenceHashMap();
    private static final Map<Environment, Set<EndpointExposureOutcomeContributor>> exposureOutcomeContributorsCache = new ConcurrentReferenceHashMap();

    OnAvailableEndpointCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        MergedAnnotation conditionAnnotation = metadata.getAnnotations().get(ConditionalOnAvailableEndpoint.class);
        Class<?> target = this.getTarget(context, metadata, (MergedAnnotation<ConditionalOnAvailableEndpoint>)conditionAnnotation);
        MergedAnnotation<Endpoint> endpointAnnotation = this.getEndpointAnnotation(target);
        return this.getMatchOutcome(context, (MergedAnnotation<ConditionalOnAvailableEndpoint>)conditionAnnotation, endpointAnnotation);
    }

    private Class<?> getTarget(ConditionContext context, AnnotatedTypeMetadata metadata, MergedAnnotation<ConditionalOnAvailableEndpoint> condition) {
        Class target = condition.getClass("endpoint");
        if (target != Void.class) {
            return target;
        }
        Assert.state((metadata instanceof MethodMetadata && metadata.isAnnotated(Bean.class.getName()) ? 1 : 0) != 0, (String)"EndpointCondition must be used on @Bean methods when the endpoint is not specified");
        MethodMetadata methodMetadata = (MethodMetadata)metadata;
        try {
            return ClassUtils.forName((String)methodMetadata.getReturnTypeName(), (ClassLoader)context.getClassLoader());
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to extract endpoint id for " + methodMetadata.getDeclaringClassName() + "." + methodMetadata.getMethodName(), ex);
        }
    }

    protected MergedAnnotation<Endpoint> getEndpointAnnotation(Class<?> target) {
        MergedAnnotations annotations = MergedAnnotations.from(target, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
        MergedAnnotation endpoint = annotations.get(Endpoint.class);
        if (endpoint.isPresent()) {
            return endpoint;
        }
        MergedAnnotation extension = annotations.get(EndpointExtension.class);
        Assert.state((boolean)extension.isPresent(), (String)"No endpoint is specified and the return type of the @Bean method is neither an @Endpoint, nor an @EndpointExtension");
        return this.getEndpointAnnotation(extension.getClass("endpoint"));
    }

    private ConditionOutcome getMatchOutcome(ConditionContext context, MergedAnnotation<ConditionalOnAvailableEndpoint> conditionAnnotation, MergedAnnotation<Endpoint> endpointAnnotation) {
        EndpointId endpointId;
        ConditionMessage.Builder message = ConditionMessage.forCondition(ConditionalOnAvailableEndpoint.class, (Object[])new Object[0]);
        Environment environment = context.getEnvironment();
        ConditionOutcome accessOutcome = this.getAccessOutcome(environment, endpointAnnotation, endpointId = EndpointId.of((Environment)environment, (String)endpointAnnotation.getString("id")), message);
        if (!accessOutcome.isMatch()) {
            return accessOutcome;
        }
        ConditionOutcome exposureOutcome = this.getExposureOutcome(context, conditionAnnotation, endpointAnnotation, endpointId, message);
        return exposureOutcome != null ? exposureOutcome : ConditionOutcome.noMatch((ConditionMessage)message.because("not exposed"));
    }

    private ConditionOutcome getAccessOutcome(Environment environment, MergedAnnotation<Endpoint> endpointAnnotation, EndpointId endpointId, ConditionMessage.Builder message) {
        Access defaultAccess = (Access)endpointAnnotation.getEnum("defaultAccess", Access.class);
        boolean enableByDefault = endpointAnnotation.getBoolean("enableByDefault");
        Access access = this.getAccess(environment, endpointId, enableByDefault ? defaultAccess : Access.NONE);
        return new ConditionOutcome(access != Access.NONE, message.because("the configured access for endpoint '%s' is %s".formatted(endpointId, access)));
    }

    private Access getAccess(Environment environment, EndpointId endpointId, Access defaultAccess) {
        return accessResolversCache.computeIfAbsent(environment, PropertiesEndpointAccessResolver::new).accessFor(endpointId, defaultAccess);
    }

    private ConditionOutcome getExposureOutcome(ConditionContext context, MergedAnnotation<ConditionalOnAvailableEndpoint> conditionAnnotation, MergedAnnotation<Endpoint> endpointAnnotation, EndpointId endpointId, ConditionMessage.Builder message) {
        Set<EndpointExposure> exposures = this.getExposures(conditionAnnotation);
        Set<EndpointExposureOutcomeContributor> outcomeContributors = this.getExposureOutcomeContributors(context);
        for (EndpointExposureOutcomeContributor outcomeContributor : outcomeContributors) {
            ConditionOutcome outcome = outcomeContributor.getExposureOutcome(endpointId, exposures, message);
            if (outcome == null || !outcome.isMatch()) continue;
            return outcome;
        }
        return null;
    }

    private Set<EndpointExposure> getExposures(MergedAnnotation<ConditionalOnAvailableEndpoint> conditionAnnotation) {
        EndpointExposure[] exposures = (EndpointExposure[])conditionAnnotation.getEnumArray("exposure", EndpointExposure.class);
        return this.replaceCloudFoundryExposure(exposures.length == 0 ? EnumSet.allOf(EndpointExposure.class) : Arrays.asList(exposures));
    }

    private Set<EndpointExposure> replaceCloudFoundryExposure(Collection<EndpointExposure> exposures) {
        EnumSet<EndpointExposure> result = EnumSet.copyOf(exposures);
        if (result.remove((Object)EndpointExposure.CLOUD_FOUNDRY)) {
            result.add(EndpointExposure.WEB);
        }
        return result;
    }

    private Set<EndpointExposureOutcomeContributor> getExposureOutcomeContributors(ConditionContext context) {
        Environment environment = context.getEnvironment();
        Set<EndpointExposureOutcomeContributor> contributors = exposureOutcomeContributorsCache.get(environment);
        if (contributors == null) {
            contributors = new LinkedHashSet<EndpointExposureOutcomeContributor>();
            contributors.add(new StandardExposureOutcomeContributor(environment, EndpointExposure.WEB));
            if (((Boolean)environment.getProperty(JMX_ENABLED_KEY, Boolean.class, (Object)false)).booleanValue()) {
                contributors.add(new StandardExposureOutcomeContributor(environment, EndpointExposure.JMX));
            }
            contributors.addAll(this.loadExposureOutcomeContributors(context.getClassLoader(), environment));
            exposureOutcomeContributorsCache.put(environment, contributors);
        }
        return contributors;
    }

    private List<EndpointExposureOutcomeContributor> loadExposureOutcomeContributors(ClassLoader classLoader, Environment environment) {
        SpringFactoriesLoader.ArgumentResolver argumentResolver = SpringFactoriesLoader.ArgumentResolver.of(Environment.class, (Object)environment);
        return SpringFactoriesLoader.forDefaultResourceLocation((ClassLoader)classLoader).load(EndpointExposureOutcomeContributor.class, argumentResolver);
    }

    private static class StandardExposureOutcomeContributor
    implements EndpointExposureOutcomeContributor {
        private final EndpointExposure exposure;
        private final String property;
        private final IncludeExcludeEndpointFilter<?> filter;

        StandardExposureOutcomeContributor(Environment environment, EndpointExposure exposure) {
            this.exposure = exposure;
            String name = exposure.name().toLowerCase(Locale.ROOT).replace('_', '-');
            this.property = "management.endpoints." + name + ".exposure";
            this.filter = new IncludeExcludeEndpointFilter<ExposableEndpoint>(ExposableEndpoint.class, environment, this.property, exposure.getDefaultIncludes());
        }

        @Override
        public ConditionOutcome getExposureOutcome(EndpointId endpointId, Set<EndpointExposure> exposures, ConditionMessage.Builder message) {
            if (exposures.contains((Object)this.exposure) && this.filter.match(endpointId)) {
                return ConditionOutcome.match((ConditionMessage)message.because("marked as exposed by a '" + this.property + "' property"));
            }
            return null;
        }
    }
}

