/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.ProcessDefinitionQueryImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.DeploymentEntity;
import org.flowable.engine.impl.repository.AddAsNewDeploymentMergeStrategy;
import org.flowable.engine.impl.repository.AddAsOldDeploymentMergeStrategy;
import org.flowable.engine.impl.repository.MergeByDateDeploymentMergeStrategy;
import org.flowable.engine.impl.repository.VerifyDeploymentMergeStrategy;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.DeploymentMergeStrategy;
import org.flowable.engine.repository.MergeMode;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.job.service.JobService;

public class ChangeDeploymentTenantIdCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String deploymentId;
    protected String newTenantId;
    protected DeploymentMergeStrategy deploymentMergeStrategy;

    public ChangeDeploymentTenantIdCmd(String deploymentId, String newTenantId) {
        this(deploymentId, newTenantId, MergeMode.VERIFY);
    }

    public ChangeDeploymentTenantIdCmd(String deploymentId, String newTenantId, MergeMode mergeMode) {
        this.deploymentId = deploymentId;
        this.newTenantId = newTenantId;
        switch (mergeMode) {
            case VERIFY: {
                this.deploymentMergeStrategy = new VerifyDeploymentMergeStrategy();
                break;
            }
            case AS_NEW: {
                this.deploymentMergeStrategy = new AddAsNewDeploymentMergeStrategy();
                break;
            }
            case AS_OLD: {
                this.deploymentMergeStrategy = new AddAsOldDeploymentMergeStrategy();
                break;
            }
            case BY_DATE: {
                this.deploymentMergeStrategy = new MergeByDateDeploymentMergeStrategy();
                break;
            }
            default: {
                throw new FlowableException("Merge mode '" + String.valueOf((Object)mergeMode) + "' not found.");
            }
        }
    }

    public ChangeDeploymentTenantIdCmd(String deploymentId, String newTenantId, DeploymentMergeStrategy deploymentMergeStrategy) {
        this.deploymentId = deploymentId;
        this.newTenantId = newTenantId;
        this.deploymentMergeStrategy = deploymentMergeStrategy;
    }

    public Void execute(CommandContext commandContext) {
        if (this.deploymentId == null) {
            throw new FlowableIllegalArgumentException("deploymentId is null");
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        DeploymentEntity deployment = (DeploymentEntity)processEngineConfiguration.getDeploymentEntityManager().findById(this.deploymentId);
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("Could not find deployment with id " + this.deploymentId, Deployment.class);
        }
        if (Flowable5Util.isFlowable5Deployment((Deployment)deployment, commandContext)) {
            processEngineConfiguration.getFlowable5CompatibilityHandler().changeDeploymentTenantId(this.deploymentId, this.newTenantId);
            return null;
        }
        this.deploymentMergeStrategy.prepareMerge(commandContext, this.deploymentId, this.newTenantId);
        String oldTenantId = deployment.getTenantId();
        deployment.setTenantId(this.newTenantId);
        processEngineConfiguration.getProcessDefinitionEntityManager().updateProcessDefinitionTenantIdForDeployment(this.deploymentId, this.newTenantId);
        processEngineConfiguration.getExecutionEntityManager().updateExecutionTenantIdForDeployment(this.deploymentId, this.newTenantId);
        processEngineConfiguration.getTaskServiceConfiguration().getTaskService().updateTaskTenantIdForDeployment(this.deploymentId, this.newTenantId);
        JobService jobService = processEngineConfiguration.getJobServiceConfiguration().getJobService();
        jobService.updateAllJobTypesTenantIdForDeployment(this.deploymentId, this.newTenantId);
        processEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService().updateEventSubscriptionTenantId(oldTenantId, this.newTenantId);
        this.deploymentMergeStrategy.finalizeMerge(commandContext, this.deploymentId, this.newTenantId);
        List processDefinitions = new ProcessDefinitionQueryImpl().deploymentId(this.deploymentId).list();
        for (ProcessDefinition processDefinition : processDefinitions) {
            processEngineConfiguration.getProcessDefinitionCache().remove(processDefinition.getId());
        }
        processEngineConfiguration.getProcessDefinitionCache().clear();
        return null;
    }
}

