/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.windowing;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.storm.windowing.Event;
import org.apache.storm.windowing.EvictionContext;
import org.apache.storm.windowing.EvictionPolicy;

public class CountEvictionPolicy<T>
implements EvictionPolicy<T, Long> {
    protected final int threshold;
    protected final AtomicLong currentCount;
    private EvictionContext context;

    public CountEvictionPolicy(int count) {
        this.threshold = count;
        this.currentCount = new AtomicLong();
    }

    @Override
    public EvictionPolicy.Action evict(Event<T> event) {
        long curVal;
        while ((curVal = this.currentCount.get()) > (long)this.threshold) {
            if (!this.currentCount.compareAndSet(curVal, curVal - 1L)) continue;
            return EvictionPolicy.Action.EXPIRE;
        }
        return EvictionPolicy.Action.PROCESS;
    }

    @Override
    public void track(Event<T> event) {
        if (!event.isWatermark()) {
            this.currentCount.incrementAndGet();
        }
    }

    @Override
    public EvictionContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(EvictionContext context) {
        this.context = context;
    }

    public String toString() {
        return "CountEvictionPolicy{threshold=" + this.threshold + ", currentCount=" + String.valueOf(this.currentCount) + "}";
    }

    @Override
    public void reset() {
    }

    @Override
    public Long getState() {
        return this.currentCount.get();
    }

    @Override
    public void restoreState(Long state) {
        this.currentCount.set(state);
    }
}

