/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.util.LinkedHashMap;
import java.util.Map;

public class LruMap<A, B>
extends LinkedHashMap<A, B> {
    private int maxSize;
    private CacheEvictionCallback evCb = null;

    public LruMap(int maxSize) {
        super(maxSize + 1, 1.0f, true);
        this.maxSize = maxSize;
    }

    public LruMap(int maxSize, CacheEvictionCallback evictionCallback) {
        this(maxSize);
        this.evCb = evictionCallback;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<A, B> eldest) {
        boolean evict;
        boolean bl = evict = this.size() > this.maxSize;
        if (evict && this.evCb != null) {
            this.evCb.evictionCallback(eldest.getKey(), eldest.getValue());
        }
        return evict;
    }

    public static interface CacheEvictionCallback<K, V> {
        public void evictionCallback(K var1, V var2);
    }
}

