/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.jcrmock.resource;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.testing.mock.jcr.MockJcr;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class FindResourcesTest {
    @Rule
    public SlingContext context = new SlingContext(ResourceResolverType.JCR_MOCK);

    @Before
    public void setUp() {
        Resource resource = this.context.create().resource("/test", Map.of("prop1", "value1", "prop2", "value2"));
        Node node = (Node)resource.adaptTo(Node.class);
        Session session = (Session)this.context.resourceResolver().adaptTo(Session.class);
        MockJcr.setQueryResult((Session)session, Collections.singletonList(node));
    }

    @Test
    public void testFindResources() {
        Resource resource = this.context.resourceResolver().getResource("/test");
        Assert.assertNotNull((String)"Resource with name 'test' should be there", (Object)resource);
        Iterator result = this.context.resourceResolver().findResources("/test", "xpath");
        Assert.assertTrue((String)"At least one result expected", (boolean)result.hasNext());
        Assert.assertEquals((Object)"/test", (Object)((Resource)result.next()).getPath());
        Assert.assertFalse((String)"At most one result expected", (boolean)result.hasNext());
    }
}

