/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.base;

import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.apache.sis.filter.base.WarningEvent;
import org.apache.sis.storage.event.StoreListeners;

public final class WarningAdapter
implements Consumer<WarningEvent> {
    private final StoreListeners listeners;

    public WarningAdapter(StoreListeners listeners) {
        this.listeners = listeners;
    }

    @Override
    public void accept(WarningEvent event) {
        this.listeners.warning(event.recoverable ? Level.FINE : Level.WARNING, null, event.exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V execute(Supplier<V> action, StoreListeners listeners) {
        ThreadLocal context = WarningEvent.LISTENER;
        Consumer old = (Consumer)context.get();
        try {
            context.set(new WarningAdapter(listeners));
            V v = action.get();
            return v;
        }
        finally {
            context.set(old);
        }
    }
}

