/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.internal;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.DefaultObjectDomain;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.cs.DefaultCartesianCS;
import org.apache.sis.referencing.cs.DefaultCoordinateSystemAxis;
import org.apache.sis.referencing.internal.shared.ReferencingUtilities;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.util.InternationalString;

public final class Legacy {
    public static final String DERIVED_TYPE_KEY = "derivedType";
    private static final CartesianCS GEOCENTRIC = new DefaultCartesianCS((Map<String, ?>)Map.of("name", "Legacy geocentric"), (CoordinateSystemAxis)new DefaultCoordinateSystemAxis(Map.of("name", "X"), "X", AxisDirection.OTHER, Units.METRE), (CoordinateSystemAxis)new DefaultCoordinateSystemAxis(Map.of("name", "Y"), "Y", AxisDirection.EAST, Units.METRE), (CoordinateSystemAxis)new DefaultCoordinateSystemAxis(Map.of("name", "Z"), "Z", AxisDirection.NORTH, Units.METRE));

    private Legacy() {
    }

    public static CartesianCS standard(Unit<?> unit) {
        return Legacy.replaceUnit((CartesianCS)CommonCRS.WGS84.geocentric().getCoordinateSystem(), unit);
    }

    public static CartesianCS forGeocentricCRS(CartesianCS cs, boolean toLegacy) {
        CartesianCS check = toLegacy ? Legacy.standard(null) : GEOCENTRIC;
        int dimension = check.getDimension();
        if (cs.getDimension() != dimension) {
            return cs;
        }
        for (int i = 0; i < dimension; ++i) {
            if (cs.getAxis(i).getDirection().equals((Object)check.getAxis(i).getDirection())) continue;
            return cs;
        }
        Unit<?> unit = ReferencingUtilities.getUnit((CoordinateSystem)cs);
        return toLegacy ? Legacy.replaceUnit(GEOCENTRIC, unit) : Legacy.standard(unit);
    }

    public static CartesianCS replaceUnit(CartesianCS cs, Unit<?> unit) {
        if (unit != null && !unit.equals((Object)Units.METRE)) {
            cs = (CartesianCS)CoordinateSystems.replaceLinearUnit((CoordinateSystem)cs, (Unit<Length>)unit.asType(Length.class));
        }
        return cs;
    }

    public static Collection<DefaultObjectDomain> getDomains(IdentifiedObject object) {
        Extent domainOfValidity;
        InternationalString scope;
        if (object instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)object).getDomains();
        }
        if (object instanceof ReferenceSystem) {
            ReferenceSystem c = (ReferenceSystem)object;
            scope = c.getScope();
            domainOfValidity = c.getDomainOfValidity();
        } else if (object instanceof Datum) {
            Datum c = (Datum)object;
            scope = c.getScope();
            domainOfValidity = c.getDomainOfValidity();
        } else if (object instanceof CoordinateOperation) {
            CoordinateOperation c = (CoordinateOperation)object;
            scope = c.getScope();
            domainOfValidity = c.getDomainOfValidity();
        } else {
            return null;
        }
        if (scope == null && domainOfValidity == null) {
            return null;
        }
        return List.of(new DefaultObjectDomain(scope, domainOfValidity));
    }

    public static InternationalString getScope(Collection<DefaultObjectDomain> domains) {
        return domains.stream().map(DefaultObjectDomain::getScope).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static Extent getDomainOfValidity(Collection<DefaultObjectDomain> domains) {
        return domains.stream().map(DefaultObjectDomain::getDomainOfValidity).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static Date toDate(Temporal t) {
        Instant instant;
        if (t instanceof Instant) {
            instant = (Instant)t;
        } else {
            OffsetDateTime odt;
            if (t instanceof OffsetDateTime) {
                odt = (OffsetDateTime)t;
            } else if (t instanceof ZonedDateTime) {
                odt = ((ZonedDateTime)t).toOffsetDateTime();
            } else if (t instanceof LocalDateTime) {
                odt = ((LocalDateTime)t).atOffset(ZoneOffset.UTC);
            } else {
                LocalDate date;
                if (t instanceof LocalDate) {
                    date = (LocalDate)t;
                } else if (t instanceof YearMonth) {
                    date = ((YearMonth)t).atDay(1);
                } else if (t instanceof Year) {
                    date = ((Year)t).atDay(1);
                } else {
                    return null;
                }
                odt = date.atTime(OffsetTime.of(LocalTime.MIDNIGHT, ZoneOffset.UTC));
            }
            instant = odt.toInstant();
        }
        return new Date(instant.toEpochMilli());
    }
}

