/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.scheduledexecutor.impl;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.scheduledexecutor.ScheduledTaskHandler;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorDataSerializerHook;
import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;

public final class ScheduledTaskHandlerImpl
extends ScheduledTaskHandler {
    private static final String URN_BASE = "urn:hzScheduledTaskHandler:";
    private static final char DESC_SEP = '\u0000';
    private static final int URN_PARTS = 4;
    private UUID uuid;
    private int partitionId;
    private String schedulerName;
    private String taskName;

    public ScheduledTaskHandlerImpl() {
    }

    public ScheduledTaskHandlerImpl(UUID uuid, int partitionId, String schedulerName, String taskName) {
        this.uuid = uuid;
        this.partitionId = partitionId;
        this.schedulerName = schedulerName;
        this.taskName = taskName;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public String getSchedulerName() {
        return this.schedulerName;
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public boolean isAssignedToPartition() {
        return this.uuid == null;
    }

    @Override
    public boolean isAssignedToMember() {
        return this.uuid != null;
    }

    @Override
    public String toUrn() {
        return URN_BASE + (Serializable)(this.uuid == null ? "-" : this.uuid) + "\u0000" + this.partitionId + "\u0000" + this.schedulerName + "\u0000" + this.taskName;
    }

    @Override
    public int getFactoryId() {
        return ScheduledExecutorDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.toUrn());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        ScheduledTaskHandler handler = ScheduledTaskHandlerImpl.of(in.readString());
        this.uuid = handler.getUuid();
        this.partitionId = handler.getPartitionId();
        this.schedulerName = handler.getSchedulerName();
        this.taskName = handler.getTaskName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduledTaskHandlerImpl that = (ScheduledTaskHandlerImpl)o;
        if (this.partitionId != that.partitionId) {
            return false;
        }
        if (this.uuid != null ? !this.uuid.equals(that.uuid) : that.uuid != null) {
            return false;
        }
        if (!this.schedulerName.equals(that.schedulerName)) {
            return false;
        }
        return this.taskName.equals(that.taskName);
    }

    public int hashCode() {
        int result = this.uuid != null ? this.uuid.hashCode() : 0;
        result = 31 * result + this.partitionId;
        result = 31 * result + this.schedulerName.hashCode();
        result = 31 * result + this.taskName.hashCode();
        return result;
    }

    public String toString() {
        return "ScheduledTaskHandler{uuid=" + this.uuid + ", partitionId=" + this.partitionId + ", schedulerName='" + this.schedulerName + "', taskName='" + this.taskName + "'}";
    }

    void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public static ScheduledTaskHandler of(UUID uuid, String schedulerName, String taskName) {
        return new ScheduledTaskHandlerImpl(uuid, -1, schedulerName, taskName);
    }

    public static ScheduledTaskHandler of(int partitionId, String schedulerName, String taskName) {
        return new ScheduledTaskHandlerImpl(null, partitionId, schedulerName, taskName);
    }

    public static ScheduledTaskHandler of(String urn) {
        if (!urn.startsWith(URN_BASE)) {
            throw new IllegalArgumentException("Wrong urn format.");
        }
        String[] parts = (urn = urn.replace(URN_BASE, "")).split(String.valueOf('\u0000'));
        if (parts.length != 4) {
            throw new IllegalArgumentException("Wrong urn format.");
        }
        UUID uuid = null;
        if (!"-".equals(parts[0])) {
            uuid = UUID.fromString(parts[0]);
        }
        int partitionId = Integer.parseInt(parts[1]);
        String scheduler = parts[2];
        String task = parts[3];
        return new ScheduledTaskHandlerImpl(uuid, partitionId, scheduler, task);
    }
}

