/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.scheduledexecutor.impl;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.scheduledexecutor.NamedTask;
import com.hazelcast.scheduledexecutor.impl.AbstractTaskDecorator;
import java.io.IOException;
import java.util.concurrent.Callable;

public class NamedTaskDecorator<V>
extends AbstractTaskDecorator<V>
implements NamedTask,
Versioned {
    private String name;

    NamedTaskDecorator() {
    }

    private NamedTaskDecorator(String name, Runnable runnable) {
        super(runnable);
        this.name = name;
    }

    private NamedTaskDecorator(String name, Callable<V> callable) {
        super(callable);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getClassId() {
        return 5;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeString(this.name);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.name = in.readString();
    }

    public static Runnable named(String name, Runnable runnable) {
        return new NamedTaskDecorator(name, runnable);
    }

    public static <V> Callable<V> named(String name, Callable<V> callable) {
        return new NamedTaskDecorator<V>(name, callable);
    }
}

