/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.processor.SourceProcessors;
import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.Sources;
import com.hazelcast.jet.pipeline.StreamSource;
import com.hazelcast.security.impl.function.SecuredFunctions;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class FileSourceBuilder {
    private static final String GLOB_WILDCARD = "*";
    private final String directory;
    private String glob = "*";
    private boolean sharedFileSystem;
    private Charset charset = StandardCharsets.UTF_8;

    FileSourceBuilder(@Nonnull String directory) {
        this.directory = directory;
    }

    @Nonnull
    public FileSourceBuilder glob(@Nonnull String glob) {
        this.glob = glob;
        return this;
    }

    @Nonnull
    public FileSourceBuilder sharedFileSystem(boolean sharedFileSystem) {
        this.sharedFileSystem = sharedFileSystem;
        return this;
    }

    @Nonnull
    public FileSourceBuilder charset(@Nonnull Charset charset) {
        this.charset = charset;
        return this;
    }

    @Deprecated
    @Nonnull
    public BatchSource<String> build() {
        return this.build((String filename, String line) -> line);
    }

    @Deprecated
    @Nonnull
    public <T> BatchSource<T> build(@Nonnull BiFunctionEx<String, String, ? extends T> mapOutputFn) {
        String charsetName = this.charset.name();
        return Sources.batchFromProcessor("filesSource(" + new File(this.directory, this.glob) + ")", SourceProcessors.readFilesP(this.directory, this.glob, this.sharedFileSystem, SecuredFunctions.readFileFn(this.directory, charsetName, mapOutputFn)));
    }

    @Deprecated
    @Nonnull
    public <T> BatchSource<T> build(@Nonnull FunctionEx<? super Path, ? extends Stream<T>> readFileFn) {
        return Sources.batchFromProcessor("filesSource(" + new File(this.directory, this.glob) + ")", SourceProcessors.readFilesP(this.directory, this.glob, this.sharedFileSystem, readFileFn));
    }

    @Nonnull
    public StreamSource<String> buildWatcher() {
        return this.buildWatcher((filename, line) -> line);
    }

    @Nonnull
    public <T> StreamSource<T> buildWatcher(@Nonnull BiFunctionEx<String, String, ? extends T> mapOutputFn) {
        return Sources.streamFromProcessor("fileWatcherSource(" + this.directory + "/" + this.glob + ")", SourceProcessors.streamFilesP(this.directory, this.charset, this.glob, this.sharedFileSystem, mapOutputFn));
    }
}

