/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.deployment;

import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.impl.JobRepository;
import com.hazelcast.jet.impl.deployment.MapResourceClassLoader;
import com.hazelcast.logging.ILogger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JetClassLoader
extends MapResourceClassLoader {
    private static final String JOB_URL_PROTOCOL = "jet-job-resource";
    private final long jobId;
    private final String jobName;
    private final ILogger logger;

    public JetClassLoader(@Nonnull ILogger logger, @Nullable ClassLoader parent, @Nullable String jobName, long jobId, @Nonnull JobRepository jobRepository) {
        super(parent, () -> jobRepository.getJobResources(jobId), false);
        this.jobName = jobName;
        this.jobId = jobId;
        this.logger = logger;
    }

    @Override
    boolean checkShutdown(String resource) {
        if (!this.isShutdown) {
            return false;
        }
        Object jobName = this.jobName == null ? Util.idToString(this.jobId) : "'" + this.jobName + "'";
        this.logger.warning("Classloader for job " + (String)jobName + " tried to load '" + resource + "' after the job was completed. The classloader used for jobs is disposed after job is completed");
        return true;
    }

    @Override
    protected URL findResource(String name) {
        if (this.checkShutdown(name) || StringUtil.isNullOrEmpty(name) || !((Map)this.resourcesSupplier.get()).containsKey(JobRepository.classKeyName(name))) {
            return null;
        }
        try {
            return new URL(JOB_URL_PROTOCOL, null, -1, name, new MapResourceClassLoader.MapResourceURLStreamHandler(this));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        URL resourceUrl = this.findResource(name);
        return resourceUrl == null ? Collections.emptyEnumeration() : Collections.enumeration(List.of(resourceUrl));
    }

    @Override
    ClassNotFoundException newClassNotFoundException(String name) {
        return new ClassNotFoundException(name + ". Add it using " + JobConfig.class.getSimpleName() + " or start all members with it on classpath");
    }

    public String toString() {
        return "JetClassLoader{jobName='" + this.jobName + "', jobId=" + Util.idToString(this.jobId) + "}";
    }
}

