/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.sql.DataSource;

public class DataSourceFromJdbcUrl
implements DataSource {
    private final String jdbcUrl;
    private final String username;
    private final String password;

    public DataSourceFromJdbcUrl(@Nonnull String jdbcUrl) {
        this(jdbcUrl, null, null);
    }

    public DataSourceFromJdbcUrl(@Nonnull String jdbcUrl, String username, String password) {
        this.jdbcUrl = jdbcUrl;
        this.password = password;
        this.username = username;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.username != null || this.password != null) {
            return this.getConnection(this.username, this.password);
        }
        return DriverManager.getConnection(this.jdbcUrl);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return DriverManager.getConnection(this.jdbcUrl, username, password);
    }

    @Override
    public PrintWriter getLogWriter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLogWriter(PrintWriter out) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLoginTimeout(int seconds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLoginTimeout() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        throw new UnsupportedOperationException();
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }
}

