/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.impl.util.Util;
import java.io.Serializable;

public class SlidingWindowPolicy
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long frameSize;
    private final long frameOffset;
    private final long windowSize;

    SlidingWindowPolicy(long frameSize, long frameOffset, long framesPerWindow) {
        Preconditions.checkPositive(frameSize, "frameLength must be positive");
        Preconditions.checkNotNegative(frameOffset, "frameOffset must not be negative");
        Preconditions.checkTrue(frameOffset < frameSize, "frameOffset must be less than frameSize, offset=" + frameOffset + ", size=" + frameSize);
        Preconditions.checkPositive(framesPerWindow, "framesPerWindow must be positive");
        this.frameSize = frameSize;
        this.frameOffset = frameOffset;
        this.windowSize = frameSize * framesPerWindow;
    }

    public long frameSize() {
        return this.frameSize;
    }

    public long frameOffset() {
        return this.frameOffset;
    }

    public long windowSize() {
        return this.windowSize;
    }

    public boolean isTumbling() {
        return this.windowSize == this.frameSize;
    }

    public long floorFrameTs(long timestamp) {
        return Util.subtractClamped(timestamp, Math.floorMod((timestamp >= Long.MIN_VALUE + this.frameOffset ? timestamp : timestamp + this.frameSize) - this.frameOffset, this.frameSize));
    }

    public long higherFrameTs(long timestamp) {
        long tsPlusFrame = timestamp + this.frameSize;
        return Util.sumHadOverflow(timestamp, this.frameSize, tsPlusFrame) ? Util.addClamped(this.floorFrameTs(timestamp), this.frameSize) : this.floorFrameTs(tsPlusFrame);
    }

    public SlidingWindowPolicy withOffset(long offset) {
        return new SlidingWindowPolicy(this.frameSize, offset, this.windowSize / this.frameSize);
    }

    public SlidingWindowPolicy toTumblingByFrame() {
        return new SlidingWindowPolicy(this.frameSize, this.frameOffset, 1L);
    }

    public static SlidingWindowPolicy slidingWinPolicy(long windowSize, long slideBy) {
        Preconditions.checkPositive(windowSize, "windowSize must be >= 1");
        Preconditions.checkPositive(slideBy, "slideBy must be >= 1");
        Preconditions.checkTrue(windowSize % slideBy == 0L, "windowSize must be an integer multiple of slideBy");
        return new SlidingWindowPolicy(slideBy, 0L, windowSize / slideBy);
    }

    public static SlidingWindowPolicy tumblingWinPolicy(long windowSize) {
        return SlidingWindowPolicy.slidingWinPolicy(windowSize, windowSize);
    }
}

