/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.graph;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public class Graph<V> {
    private Map<V, Set<V>> adjacencyMap = new HashMap<V, Set<V>>();

    public void add(V v) {
        Objects.requireNonNull(v);
        this.adjacencyMap.putIfAbsent(v, new HashSet());
    }

    public void connect(V v1, V v2) {
        Objects.requireNonNull(v1);
        Objects.requireNonNull(v2);
        if (v1.equals(v2)) {
            return;
        }
        this.adjacencyMap.computeIfAbsent((Set)v1, (Function<Set, Set<Set>>)((Function<Object, Set>)v -> new HashSet())).add(v2);
        this.adjacencyMap.computeIfAbsent((Set)v2, (Function<Set, Set<Set>>)((Function<Object, Set>)v -> new HashSet())).add(v1);
    }

    public void disconnect(V v1, V v2) {
        Objects.requireNonNull(v1);
        Objects.requireNonNull(v2);
        if (v1.equals(v2)) {
            return;
        }
        if (this.adjacencyMap.getOrDefault(v1, Collections.emptySet()).remove(v2)) {
            this.adjacencyMap.get(v2).remove(v1);
        }
    }

    public Set<V> vertexSet() {
        return Collections.unmodifiableSet(this.adjacencyMap.keySet());
    }

    public boolean containsEdge(V v1, V v2) {
        Objects.requireNonNull(v1);
        Objects.requireNonNull(v2);
        return this.adjacencyMap.getOrDefault(v1, Collections.emptySet()).contains(v2);
    }
}

