/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.executor;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.logging.ILogger;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;

public class LoggingScheduledExecutor
extends ScheduledThreadPoolExecutor {
    private final ILogger logger;
    private volatile boolean shutdownInitiated;

    public LoggingScheduledExecutor(ILogger logger, int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
        this.logger = Preconditions.checkNotNull(logger, "logger cannot be null");
        this.setRemoveOnCancelPolicy(true);
    }

    public LoggingScheduledExecutor(ILogger logger, int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory, handler);
        this.logger = Preconditions.checkNotNull(logger, "logger cannot be null");
        this.setRemoveOnCancelPolicy(true);
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        ScheduledFuture future;
        super.afterExecute(runnable, throwable);
        Level level = Level.FINE;
        if (throwable == null && runnable instanceof ScheduledFuture && (future = (ScheduledFuture)((Object)runnable)).isDone()) {
            try {
                future.get();
            }
            catch (CancellationException ce) {
                throwable = ce;
            }
            catch (ExecutionException ee) {
                level = Level.SEVERE;
                throwable = ee.getCause();
            }
            catch (InterruptedException ie) {
                throwable = ie;
                Thread.currentThread().interrupt();
            }
        }
        if (throwable instanceof RejectedExecutionException && this.shutdownInitiated) {
            level = Level.FINE;
        }
        if (throwable != null) {
            this.logger.log(level, "Failed to execute " + runnable, throwable);
        }
    }

    public void notifyShutdownInitiated() {
        this.shutdownInitiated = true;
    }
}

