/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.util;

import java.nio.ByteBuffer;

public final class BufferUtil {
    private BufferUtil() {
    }

    public static void compactOrClear(ByteBuffer bb) {
        if (bb.hasRemaining()) {
            bb.compact();
        } else {
            bb.clear();
        }
    }

    public static ByteBuffer allocateBuffer(boolean direct, int capacity) {
        return direct ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
    }

    public static void put(ByteBuffer dst, ByteBuffer src) {
        if (src.remaining() <= dst.remaining()) {
            dst.put(src);
        } else {
            int srcOldLimit = src.limit();
            src.limit(src.position() + dst.remaining());
            dst.put(src);
            src.limit(srcOldLimit);
        }
    }
}

