/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.operation;

import com.hazelcast.config.Config;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.internal.dynamicconfig.ConfigurationService;
import com.hazelcast.internal.management.operation.AbstractManagementOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class UpdateTcpIpMemberListOperation
extends AbstractManagementOperation {
    private List<String> members;

    public UpdateTcpIpMemberListOperation() {
    }

    public UpdateTcpIpMemberListOperation(List<String> members) {
        this.members = members;
    }

    @Override
    public void run() throws Exception {
        TcpIpConfig tcpIpConfig;
        Object activeNetworkConfig;
        Config config = this.getNodeEngine().getNode().getConfig();
        if (config.getAdvancedNetworkConfig().isEnabled()) {
            activeNetworkConfig = config.getAdvancedNetworkConfig();
            tcpIpConfig = config.getAdvancedNetworkConfig().getJoin().getTcpIpConfig();
        } else {
            activeNetworkConfig = config.getNetworkConfig();
            tcpIpConfig = config.getNetworkConfig().getJoin().getTcpIpConfig();
        }
        if (tcpIpConfig.isEnabled()) {
            tcpIpConfig.setMembers(this.members);
            try {
                ConfigurationService configurationService = (ConfigurationService)this.getNodeEngine().getService("hz:configurationService");
                configurationService.persist(activeNetworkConfig);
            }
            catch (Exception exception) {}
        } else {
            throw new IllegalStateException("TCP-IP join mechanism is not enabled in the cluster.");
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        this.members = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            String member = in.readString();
            this.members.add(member);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.members.size());
        for (String member : this.members) {
            out.writeString(member);
        }
    }

    @Override
    public int getClassId() {
        return 7;
    }
}

