/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl.operations;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.instance.impl.ClusterTopologyIntent;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.cluster.impl.MembersView;
import com.hazelcast.internal.cluster.impl.operations.JoinOperation;
import com.hazelcast.internal.cluster.impl.operations.MembersUpdateOp;
import com.hazelcast.internal.cluster.impl.operations.OnJoinOp;
import com.hazelcast.internal.hotrestart.InternalHotRestartService;
import com.hazelcast.internal.partition.PartitionRuntimeState;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationAccessor;
import com.hazelcast.spi.impl.operationservice.OperationResponseHandlerFactory;
import com.hazelcast.spi.impl.operationservice.TargetAware;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.version.Version;
import java.io.IOException;
import java.util.Collection;
import java.util.UUID;

public class FinalizeJoinOp
extends MembersUpdateOp
implements TargetAware {
    private OnJoinOp preJoinOp;
    private OnJoinOp postJoinOp;
    private UUID clusterId;
    private long clusterStartTime;
    private ClusterState clusterState;
    private Version clusterVersion;
    private boolean deferPartitionProcessing;
    private ClusterTopologyIntent clusterTopologyIntent;
    private transient boolean finalized;
    private transient Exception deserializationFailure;

    public FinalizeJoinOp() {
    }

    public FinalizeJoinOp(UUID targetUuid, MembersView members, OnJoinOp preJoinOp, OnJoinOp postJoinOp, long masterTime, UUID clusterId, long clusterStartTime, ClusterState clusterState, Version clusterVersion, PartitionRuntimeState partitionRuntimeState, boolean deferPartitionProcessing, ClusterTopologyIntent clusterTopologyIntent) {
        super(targetUuid, members, masterTime, partitionRuntimeState, true);
        this.preJoinOp = preJoinOp;
        this.postJoinOp = postJoinOp;
        this.clusterId = clusterId;
        this.clusterStartTime = clusterStartTime;
        this.clusterState = clusterState;
        this.clusterVersion = clusterVersion;
        this.deferPartitionProcessing = deferPartitionProcessing;
        this.clusterTopologyIntent = clusterTopologyIntent;
    }

    @Override
    public void run() throws Exception {
        boolean hrServiceEnabled;
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        Address callerAddress = this.getConnectionEndpointOrThisAddress();
        UUID callerUuid = this.getCallerUuid();
        UUID targetUuid = this.getTargetUuid();
        this.checkDeserializationFailure(clusterService);
        this.preparePostOp(this.preJoinOp);
        InternalHotRestartService hrService = this.getInternalHotRestartService();
        boolean bl = hrServiceEnabled = hrService != null && hrService.isEnabled();
        if (hrServiceEnabled) {
            hrService.setRejoiningActiveCluster(this.deferPartitionProcessing);
            hrService.setClusterTopologyIntentOnMaster(this.clusterTopologyIntent);
        }
        this.finalized = clusterService.finalizeJoin(this.getMembersView(), callerAddress, callerUuid, targetUuid, this.clusterId, this.clusterState, this.clusterVersion, this.clusterStartTime, this.masterTime, this.preJoinOp);
        if (!this.finalized) {
            return;
        }
        if (this.deferPartitionProcessing && hrServiceEnabled && this.partitionRuntimeState != null) {
            this.partitionRuntimeState.setMaster(this.getCallerAddress());
            hrService.deferApplyPartitionState(this.partitionRuntimeState);
        } else {
            this.processPartitionState();
        }
    }

    private InternalHotRestartService getInternalHotRestartService() {
        return (InternalHotRestartService)this.getNodeEngine().getServiceOrNull("hz:ee:internalHotRestartService");
    }

    private void checkDeserializationFailure(ClusterServiceImpl clusterService) {
        if (this.deserializationFailure != null) {
            this.getLogger().severe("Node could not join cluster.", this.deserializationFailure);
            Node node = clusterService.getNodeEngine().getNode();
            JoinOperation.verifyCanShutdown(node, this.deserializationFailure.getMessage());
            node.shutdown(true);
            throw ExceptionUtil.rethrow(this.deserializationFailure);
        }
    }

    @Override
    public void afterRun() throws Exception {
        super.afterRun();
        if (!this.finalized) {
            return;
        }
        boolean shouldExecutePostJoinOp = this.preparePostOp(this.postJoinOp);
        if (this.getInternalHotRestartService() != null && this.getInternalHotRestartService().isEnabled() && (this.deferPartitionProcessing || !this.getInternalHotRestartService().isStartCompleted())) {
            this.getInternalHotRestartService().deferPostJoinOps(this.postJoinOp);
            return;
        }
        this.sendPostJoinOperationsBackToMaster();
        if (shouldExecutePostJoinOp) {
            this.getNodeEngine().getOperationService().run(this.postJoinOp);
        }
    }

    private boolean preparePostOp(Operation postOp) {
        if (postOp == null) {
            return false;
        }
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        NodeEngineImpl nodeEngine = clusterService.getNodeEngine();
        postOp.setNodeEngine(nodeEngine);
        OperationAccessor.setCallerAddress(postOp, this.getCallerAddress());
        OperationAccessor.setConnection(postOp, this.getConnection());
        postOp.setOperationResponseHandler(OperationResponseHandlerFactory.createEmptyResponseHandler());
        return true;
    }

    private void sendPostJoinOperationsBackToMaster() {
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        NodeEngineImpl nodeEngine = clusterService.getNodeEngine();
        Collection<Operation> postJoinOperations = nodeEngine.getPostJoinOperations();
        if (postJoinOperations != null && !postJoinOperations.isEmpty()) {
            OperationServiceImpl operationService = nodeEngine.getOperationService();
            Address masterAddress = clusterService.getMasterAddress();
            OnJoinOp operation = new OnJoinOp(postJoinOperations);
            operationService.invokeOnTarget("hz:core:clusterService", operation, masterAddress);
        }
    }

    @Override
    protected void writeInternalImpl(ObjectDataOutput out) throws IOException {
        super.writeInternalImpl(out);
        UUIDSerializationUtil.writeUUID(out, this.clusterId);
        out.writeLong(this.clusterStartTime);
        out.writeString(this.clusterState.toString());
        out.writeObject(this.clusterVersion);
        out.writeObject(this.preJoinOp);
        out.writeObject(this.postJoinOp);
        out.writeBoolean(this.deferPartitionProcessing);
        out.writeByte(this.clusterTopologyIntent.getId());
    }

    @Override
    protected void readInternalImpl(ObjectDataInput in) throws IOException {
        super.readInternalImpl(in);
        this.clusterId = UUIDSerializationUtil.readUUID(in);
        this.clusterStartTime = in.readLong();
        String stateName = in.readString();
        this.clusterState = ClusterState.valueOf(stateName);
        this.clusterVersion = (Version)in.readObject();
        this.preJoinOp = this.readOnJoinOp(in);
        this.postJoinOp = this.readOnJoinOp(in);
        if (this.deserializationFailure != null) {
            return;
        }
        this.deferPartitionProcessing = in.readBoolean();
        byte topologyIntentId = in.readByte();
        this.clusterTopologyIntent = ClusterTopologyIntent.of(topologyIntentId);
    }

    private OnJoinOp readOnJoinOp(ObjectDataInput in) {
        if (this.deserializationFailure != null) {
            return null;
        }
        try {
            return (OnJoinOp)in.readObject();
        }
        catch (Exception e) {
            this.deserializationFailure = e;
            return null;
        }
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", postJoinOp=").append(this.postJoinOp);
    }

    @Override
    public int getClassId() {
        return 7;
    }

    @Override
    public void setTarget(Address address) {
        if (this.preJoinOp != null) {
            this.preJoinOp.setTarget(address);
        }
        if (this.postJoinOp != null) {
            this.postJoinOp.setTarget(address);
        }
    }
}

