/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config.vector;

import com.hazelcast.config.NamedConfig;
import com.hazelcast.config.vector.VectorIndexConfig;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.annotation.Beta;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Beta
public class VectorCollectionConfig
implements NamedConfig,
IdentifiedDataSerializable {
    private String name;
    private final List<VectorIndexConfig> vectorIndexConfigs = new ArrayList<VectorIndexConfig>();

    public VectorCollectionConfig() {
    }

    public VectorCollectionConfig(String name) {
        VectorCollectionConfig.validateName(name);
        this.name = name;
    }

    public VectorCollectionConfig(VectorCollectionConfig config) {
        Objects.requireNonNull(config, "config must not be null.");
        this.name = config.getName();
        this.setVectorIndexConfigs(config.getVectorIndexConfigs());
    }

    @Override
    public VectorCollectionConfig setName(String name) {
        VectorCollectionConfig.validateName(name);
        this.name = name;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public VectorCollectionConfig addVectorIndexConfig(VectorIndexConfig vectorIndexConfig) {
        Objects.requireNonNull(vectorIndexConfig, "vector index config must not be null.");
        this.vectorIndexConfigs.add(vectorIndexConfig);
        return this;
    }

    public List<VectorIndexConfig> getVectorIndexConfigs() {
        return this.vectorIndexConfigs;
    }

    public void setVectorIndexConfigs(List<VectorIndexConfig> vectorIndexConfigs) {
        this.vectorIndexConfigs.clear();
        this.vectorIndexConfigs.addAll(vectorIndexConfigs);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        SerializationUtil.writeList(this.vectorIndexConfigs, out);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.vectorIndexConfigs.clear();
        this.name = in.readString();
        List deserialized = SerializationUtil.readList(in);
        this.vectorIndexConfigs.addAll(deserialized);
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 72;
    }

    public String toString() {
        return "VectorCollectionConfig{name='" + this.name + "', vectorIndexConfigs=" + this.vectorIndexConfigs + "}";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        VectorCollectionConfig that = (VectorCollectionConfig)object;
        return Objects.equals(this.name, that.name) && Objects.equals(this.vectorIndexConfigs, that.vectorIndexConfigs);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.vectorIndexConfigs);
    }

    private static void validateName(String name) {
        String allowedSymbols = "[a-zA-Z0-9\\-*_]+";
        if (!name.matches(allowedSymbols)) {
            throw new IllegalArgumentException("The name of the vector collection should only consist of letters, numbers, and the symbols \"-\", \"_\" or \"*\".");
        }
    }
}

