/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.util;

import com.hazelcast.client.util.AbstractLoadBalancer;
import com.hazelcast.cluster.Member;
import java.util.concurrent.atomic.AtomicInteger;

public class RoundRobinLB
extends AbstractLoadBalancer {
    private final AtomicInteger indexRef;

    public RoundRobinLB() {
        this((int)System.nanoTime());
    }

    public RoundRobinLB(int seed) {
        this.indexRef = new AtomicInteger(seed);
    }

    @Override
    public Member next() {
        return this.nextInternal(false);
    }

    @Override
    public Member nextDataMember() {
        return this.nextInternal(true);
    }

    @Override
    public boolean canGetNextDataMember() {
        return true;
    }

    private Member nextInternal(boolean dataMembers) {
        Member[] members;
        Member[] memberArray = members = dataMembers ? this.getDataMembers() : this.getMembers();
        if (members == null || members.length == 0) {
            return null;
        }
        int length = members.length;
        int index = (this.indexRef.getAndAdd(1) % length + length) % length;
        return members[index];
    }
}

