/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.management;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MCTriggerHotRestartBackupCodec;
import com.hazelcast.client.impl.protocol.task.AbstractAsyncMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.security.permission.ManagementPermission;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import java.security.Permission;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;

public class HotRestartTriggerBackupMessageTask
extends AbstractAsyncMessageTask<Void, Void> {
    private static final Permission REQUIRED_PERMISSION = new ManagementPermission("hotrestart.triggerBackup");

    public HotRestartTriggerBackupMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected CompletableFuture<Void> processInternal() {
        ExecutionService executionService = this.nodeEngine.getExecutionService();
        Future<Void> future = executionService.submit("hz:async", () -> {
            this.nodeEngine.getNode().getNodeExtension().getHotRestartService().backup();
            return null;
        });
        return executionService.asCompletableFuture(future);
    }

    @Override
    protected Void decodeClientMessage(ClientMessage clientMessage) {
        return null;
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MCTriggerHotRestartBackupCodec.encodeResponse();
    }

    @Override
    public String getServiceName() {
        return "hz:core:managementCenterService";
    }

    @Override
    public Permission getRequiredPermission() {
        return REQUIRED_PERMISSION;
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "triggerHotRestartBackup";
    }

    @Override
    public Object[] getParameters() {
        return new Object[0];
    }

    @Override
    public boolean isManagementTask() {
        return true;
    }
}

