/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.BigDecimalCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.HazelcastRowValueCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListCNBooleanCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListCNByteCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListCNDoubleCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListCNFloatCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListCNIntegerCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListCNLocalDateCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListCNLocalDateTimeCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListCNLocalTimeCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListCNLongCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListCNOffsetDateTimeCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListCNShortCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListIntegerCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.HazelcastJsonValueCodec;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.client.SqlPage;
import java.util.ArrayList;
import java.util.List;

public final class SqlPageCodec {
    private SqlPageCodec() {
    }

    public static void encode(ClientMessage clientMessage, SqlPage sqlPage) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        byte[] content = new byte[]{(byte)(sqlPage.isLast() ? 1 : 0)};
        clientMessage.add(new ClientMessage.Frame(content));
        List<SqlColumnType> columnTypes = sqlPage.getColumnTypes();
        ArrayList<Integer> columnTypeIds = new ArrayList<Integer>(columnTypes.size());
        for (SqlColumnType columnType : columnTypes) {
            columnTypeIds.add(columnType.getId());
        }
        ListIntegerCodec.encode(clientMessage, columnTypeIds);
        block20: for (int i = 0; i < sqlPage.getColumnCount(); ++i) {
            SqlColumnType columnType;
            columnType = columnTypes.get(i);
            Iterable<Boolean> column = sqlPage.getColumnValuesForServer(i);
            switch (columnType) {
                case VARCHAR: {
                    ListMultiFrameCodec.encodeContainsNullable(clientMessage, column, StringCodec::encode);
                    continue block20;
                }
                case BOOLEAN: {
                    ListCNBooleanCodec.encode(clientMessage, column);
                    continue block20;
                }
                case TINYINT: {
                    ListCNByteCodec.encode(clientMessage, column);
                    continue block20;
                }
                case SMALLINT: {
                    ListCNShortCodec.encode(clientMessage, column);
                    continue block20;
                }
                case INTEGER: {
                    ListCNIntegerCodec.encode(clientMessage, column);
                    continue block20;
                }
                case BIGINT: {
                    ListCNLongCodec.encode(clientMessage, column);
                    continue block20;
                }
                case REAL: {
                    ListCNFloatCodec.encode(clientMessage, column);
                    continue block20;
                }
                case DOUBLE: {
                    ListCNDoubleCodec.encode(clientMessage, column);
                    continue block20;
                }
                case DATE: {
                    ListCNLocalDateCodec.encode(clientMessage, column);
                    continue block20;
                }
                case TIME: {
                    ListCNLocalTimeCodec.encode(clientMessage, column);
                    continue block20;
                }
                case TIMESTAMP: {
                    ListCNLocalDateTimeCodec.encode(clientMessage, column);
                    continue block20;
                }
                case TIMESTAMP_WITH_TIME_ZONE: {
                    ListCNOffsetDateTimeCodec.encode(clientMessage, column);
                    continue block20;
                }
                case DECIMAL: {
                    ListMultiFrameCodec.encode(clientMessage, column, BigDecimalCodec::encodeNullable);
                    continue block20;
                }
                case NULL: {
                    int size = 0;
                    for (Boolean ignore : column) {
                        ++size;
                    }
                    byte[] sizeBuffer = new byte[4];
                    FixedSizeTypesCodec.encodeInt(sizeBuffer, 0, size);
                    clientMessage.add(new ClientMessage.Frame(sizeBuffer));
                    continue block20;
                }
                case ROW: {
                    ListMultiFrameCodec.encodeContainsNullable(clientMessage, column, HazelcastRowValueCodec::encode);
                    continue block20;
                }
                case OBJECT: {
                    assert (SqlPage.convertToData(columnType));
                    ListMultiFrameCodec.encode(clientMessage, column, DataCodec::encodeNullable);
                    continue block20;
                }
                case JSON: {
                    ListMultiFrameCodec.encodeContainsNullable(clientMessage, column, HazelcastJsonValueCodec::encode);
                    continue block20;
                }
                default: {
                    throw new IllegalStateException("Unknown type " + columnType);
                }
            }
        }
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static SqlPage decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        boolean isLast = iterator.next().content[0] == 1;
        List<Integer> columnTypeIds = ListIntegerCodec.decode(iterator);
        ArrayList<SqlColumnType> columnTypes = new ArrayList<SqlColumnType>(columnTypeIds.size());
        ArrayList columns = new ArrayList(columnTypeIds.size());
        block19: for (int columnTypeId : columnTypeIds) {
            SqlColumnType columnType = SqlColumnType.getById(columnTypeId);
            assert (columnType != null);
            columnTypes.add(columnType);
            switch (columnType) {
                case VARCHAR: {
                    columns.add(ListMultiFrameCodec.decodeContainsNullable(iterator, StringCodec::decode));
                    continue block19;
                }
                case BOOLEAN: {
                    columns.add(ListCNBooleanCodec.decode(iterator));
                    continue block19;
                }
                case TINYINT: {
                    columns.add(ListCNByteCodec.decode(iterator));
                    continue block19;
                }
                case SMALLINT: {
                    columns.add(ListCNShortCodec.decode(iterator));
                    continue block19;
                }
                case INTEGER: {
                    columns.add(ListCNIntegerCodec.decode(iterator));
                    continue block19;
                }
                case BIGINT: {
                    columns.add(ListCNLongCodec.decode(iterator));
                    continue block19;
                }
                case REAL: {
                    columns.add(ListCNFloatCodec.decode(iterator));
                    continue block19;
                }
                case DOUBLE: {
                    columns.add(ListCNDoubleCodec.decode(iterator));
                    continue block19;
                }
                case DATE: {
                    columns.add(ListCNLocalDateCodec.decode(iterator));
                    continue block19;
                }
                case TIME: {
                    columns.add(ListCNLocalTimeCodec.decode(iterator));
                    continue block19;
                }
                case TIMESTAMP: {
                    columns.add(ListCNLocalDateTimeCodec.decode(iterator));
                    continue block19;
                }
                case TIMESTAMP_WITH_TIME_ZONE: {
                    columns.add(ListCNOffsetDateTimeCodec.decode(iterator));
                    continue block19;
                }
                case DECIMAL: {
                    columns.add(ListMultiFrameCodec.decode(iterator, BigDecimalCodec::decodeNullable));
                    continue block19;
                }
                case NULL: {
                    ClientMessage.Frame frame = iterator.next();
                    int size = FixedSizeTypesCodec.decodeInt(frame.content, 0);
                    ArrayList<Object> column = new ArrayList<Object>(size);
                    for (int i = 0; i < size; ++i) {
                        column.add(null);
                    }
                    columns.add(column);
                    continue block19;
                }
                case ROW: {
                    columns.add(ListMultiFrameCodec.decodeContainsNullable(iterator, HazelcastRowValueCodec::decode));
                    continue block19;
                }
                case OBJECT: {
                    assert (SqlPage.convertToData(columnType));
                    columns.add(ListMultiFrameCodec.decode(iterator, DataCodec::decodeNullable));
                    continue block19;
                }
                case JSON: {
                    columns.add(ListMultiFrameCodec.decodeContainsNullable(iterator, HazelcastJsonValueCodec::decode));
                    continue block19;
                }
            }
            throw new IllegalStateException("Unknown type " + columnType);
        }
        CodecUtil.fastForwardToEndFrame(iterator);
        return SqlPage.fromColumns(columnTypes, columns, isLast);
    }
}

