/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aggregation.impl;

import com.hazelcast.aggregation.Aggregator;
import com.hazelcast.aggregation.impl.AbstractAggregator;
import com.hazelcast.aggregation.impl.AggregatorDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Objects;

public final class FloatingPointSumAggregator<I>
extends AbstractAggregator<I, Number, Double>
implements IdentifiedDataSerializable {
    private double sum;

    public FloatingPointSumAggregator() {
    }

    public FloatingPointSumAggregator(String attributePath) {
        super(attributePath);
    }

    @Override
    public void accumulateExtracted(I entry, Number value) {
        this.sum += value.doubleValue();
    }

    @Override
    public void combine(Aggregator aggregator) {
        FloatingPointSumAggregator longSumAggregator = (FloatingPointSumAggregator)aggregator;
        this.sum += longSumAggregator.sum;
    }

    @Override
    public Double aggregate() {
        return this.sum;
    }

    @Override
    public int getFactoryId() {
        return AggregatorDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 9;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.attributePath);
        out.writeDouble(this.sum);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.attributePath = in.readString();
        this.sum = in.readDouble();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FloatingPointSumAggregator that = (FloatingPointSumAggregator)o;
        return Double.compare(that.sum, this.sum) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sum);
    }
}

