/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.model.snapshots;

import io.prometheus.metrics.config.EscapingScheme;
import io.prometheus.metrics.model.snapshots.DataPointSnapshot;
import io.prometheus.metrics.model.snapshots.Exemplar;
import io.prometheus.metrics.model.snapshots.Labels;
import io.prometheus.metrics.model.snapshots.MetricMetadata;
import io.prometheus.metrics.model.snapshots.MetricSnapshot;
import io.prometheus.metrics.model.snapshots.SnapshotEscaper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public class CounterSnapshot
extends MetricSnapshot {
    public CounterSnapshot(MetricMetadata metadata, Collection<CounterDataPointSnapshot> dataPoints) {
        this(metadata, dataPoints, false);
    }

    private CounterSnapshot(MetricMetadata metadata, Collection<CounterDataPointSnapshot> dataPoints, boolean internal) {
        super(metadata, dataPoints, internal);
    }

    public List<CounterDataPointSnapshot> getDataPoints() {
        return this.dataPoints;
    }

    @Override
    MetricSnapshot escape(EscapingScheme escapingScheme, List<? extends DataPointSnapshot> dataPointSnapshots) {
        return new CounterSnapshot(this.getMetadata().escape(escapingScheme), (Collection<CounterDataPointSnapshot>)dataPointSnapshots, true);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends MetricSnapshot.Builder<Builder> {
        private final List<CounterDataPointSnapshot> dataPoints = new ArrayList<CounterDataPointSnapshot>();

        private Builder() {
        }

        public Builder dataPoint(CounterDataPointSnapshot dataPoint) {
            this.dataPoints.add(dataPoint);
            return this;
        }

        @Override
        public CounterSnapshot build() {
            return new CounterSnapshot(this.buildMetadata(), this.dataPoints);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }

    public static class CounterDataPointSnapshot
    extends DataPointSnapshot {
        private final double value;
        @Nullable
        private final Exemplar exemplar;

        public CounterDataPointSnapshot(double value, Labels labels, @Nullable Exemplar exemplar, long createdTimestampMillis) {
            this(value, labels, exemplar, createdTimestampMillis, 0L);
        }

        public CounterDataPointSnapshot(double value, Labels labels, @Nullable Exemplar exemplar, long createdTimestampMillis, long scrapeTimestampMillis) {
            this(value, labels, exemplar, createdTimestampMillis, scrapeTimestampMillis, false);
        }

        public CounterDataPointSnapshot(double value, Labels labels, @Nullable Exemplar exemplar, long createdTimestampMillis, long scrapeTimestampMillis, boolean internal) {
            super(labels, createdTimestampMillis, scrapeTimestampMillis, internal);
            this.value = value;
            this.exemplar = exemplar;
            if (!internal) {
                this.validate();
            }
        }

        public double getValue() {
            return this.value;
        }

        @Nullable
        public Exemplar getExemplar() {
            return this.exemplar;
        }

        protected void validate() {
            if (this.value < 0.0) {
                throw new IllegalArgumentException(this.value + ": counters cannot have a negative value");
            }
        }

        @Override
        DataPointSnapshot escape(EscapingScheme escapingScheme) {
            return new CounterDataPointSnapshot(this.value, SnapshotEscaper.escapeLabels(this.getLabels(), escapingScheme), SnapshotEscaper.escapeExemplar(this.exemplar, escapingScheme), this.getCreatedTimestampMillis(), this.getScrapeTimestampMillis(), true);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends DataPointSnapshot.Builder<Builder> {
            @Nullable
            private Exemplar exemplar = null;
            @Nullable
            private Double value = null;
            private long createdTimestampMillis = 0L;

            private Builder() {
            }

            public Builder value(double value) {
                this.value = value;
                return this;
            }

            public Builder exemplar(@Nullable Exemplar exemplar) {
                this.exemplar = exemplar;
                return this;
            }

            public Builder createdTimestampMillis(long createdTimestampMillis) {
                this.createdTimestampMillis = createdTimestampMillis;
                return this;
            }

            public CounterDataPointSnapshot build() {
                if (this.value == null) {
                    throw new IllegalArgumentException("Missing required field: value is null.");
                }
                return new CounterDataPointSnapshot(this.value, this.labels, this.exemplar, this.createdTimestampMillis, this.scrapeTimestampMillis);
            }

            @Override
            protected Builder self() {
                return this;
            }
        }
    }
}

