/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import org.apache.openjpa.jdbc.kernel.exps.FilterValue;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.SQLBuffer;

public abstract class AbstractDB2Dictionary
extends DBDictionary {
    public int varcharCastLength = 1000;

    public AbstractDB2Dictionary() {
        this.numericTypeName = "DOUBLE";
        this.bitTypeName = "SMALLINT";
        this.smallintTypeName = "SMALLINT";
        this.tinyintTypeName = "SMALLINT";
        this.longVarbinaryTypeName = "BLOB";
        this.varbinaryTypeName = "BLOB";
        this.stringLengthFunction = "LENGTH({0})";
        this.concatenateFunction = "(CAST({0} AS VARCHAR(" + this.varcharCastLength + ")) || CAST({1} AS VARCHAR(" + this.varcharCastLength + ")))";
        this.trimLeadingFunction = "LTRIM({0})";
        this.trimTrailingFunction = "RTRIM({0})";
        this.trimBothFunction = "LTRIM(RTRIM({0}))";
        this.forUpdateClause = "FOR UPDATE WITH RR";
        this.supportsLockingWithDistinctClause = false;
        this.supportsLockingWithMultipleTables = false;
        this.supportsLockingWithOrderClause = false;
        this.supportsLockingWithOuterJoin = false;
        this.supportsLockingWithInnerJoin = false;
        this.supportsLockingWithSelectRange = true;
        this.supportsCaseConversionForLob = true;
        this.requiresAutoCommitForMetaData = true;
        this.requiresAliasForSubselect = true;
        this.supportsAutoAssign = true;
        this.autoAssignClause = "GENERATED BY DEFAULT AS IDENTITY";
        this.lastGeneratedKeyQuery = "VALUES(IDENTITY_VAL_LOCAL())";
        this.crossJoinClause = "JOIN";
        this.requiresConditionForCrossJoin = true;
    }

    @Override
    public void indexOf(SQLBuffer buf, FilterValue str, FilterValue find, FilterValue start) {
        buf.append("LOCATE(CAST((");
        find.appendTo(buf);
        buf.append(") AS VARCHAR(").append(Integer.toString(this.varcharCastLength)).append(")), CAST((");
        str.appendTo(buf);
        buf.append(") AS VARCHAR(").append(Integer.toString(this.varcharCastLength)).append("))");
        if (start != null) {
            buf.append(", CAST((");
            start.appendTo(buf);
            buf.append(") AS INTEGER)");
        }
        buf.append(")");
    }

    @Override
    public void substring(SQLBuffer buf, FilterValue str, FilterValue start, FilterValue length) {
        buf.append("SUBSTR(CAST((");
        str.appendTo(buf);
        buf.append(") AS VARCHAR(").append(Integer.toString(this.varcharCastLength)).append(")), ");
        if (start.getValue() instanceof Number) {
            buf.append(Long.toString(this.toLong(start)));
        } else {
            buf.append("CAST((");
            start.appendTo(buf);
            buf.append(") AS INTEGER)");
        }
        if (length != null) {
            buf.append(", ");
            if (length.getValue() instanceof Number) {
                buf.append(Long.toString(this.toLong(length)));
            } else {
                buf.append("CAST((");
                length.appendTo(buf);
                buf.append(") AS INTEGER)");
            }
        }
        buf.append(")");
    }
}

