/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.aci;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.aci.MicroOperation;
import org.apache.directory.api.ldap.aci.ProtectedItem;
import org.apache.directory.api.ldap.aci.UserClass;
import org.apache.directory.api.ldap.model.constants.AuthenticationLevel;

public class ACITuple {
    private final Collection<UserClass> userClasses;
    private final AuthenticationLevel authenticationLevel;
    private final Collection<ProtectedItem> protectedItems;
    private final Set<MicroOperation> microOperations;
    private final boolean grant;
    private final Integer precedence;

    public ACITuple(Collection<UserClass> userClasses, AuthenticationLevel authenticationLevel, Collection<ProtectedItem> protectedItems, Collection<MicroOperation> microOperations, boolean grant, Integer precedence) {
        if (authenticationLevel == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_07003_NULL_AUTHENTICATION_LEVEL, new Object[0]));
        }
        if (precedence < 0 || precedence > 255) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_07002_BAD_PRECENDENCE, precedence));
        }
        this.userClasses = Collections.unmodifiableCollection(new ArrayList<UserClass>(userClasses));
        this.authenticationLevel = authenticationLevel;
        this.protectedItems = Collections.unmodifiableCollection(new ArrayList<ProtectedItem>(protectedItems));
        this.microOperations = Collections.unmodifiableSet(new HashSet<MicroOperation>(microOperations));
        this.grant = grant;
        this.precedence = precedence;
    }

    public Collection<UserClass> getUserClasses() {
        return this.userClasses;
    }

    public AuthenticationLevel getAuthenticationLevel() {
        return this.authenticationLevel;
    }

    public Collection<ProtectedItem> getProtectedItems() {
        return this.protectedItems;
    }

    public Collection<MicroOperation> getMicroOperations() {
        return this.microOperations;
    }

    public boolean isGrant() {
        return this.grant;
    }

    public Integer getPrecedence() {
        return this.precedence;
    }

    public String toString() {
        return "ACITuple: userClasses=" + this.userClasses + ", authenticationLevel=" + (Object)((Object)this.authenticationLevel) + ", protectedItems=" + this.protectedItems + ", " + (this.grant ? "grants=" : "denials=") + this.microOperations + ", precedence=" + this.precedence;
    }
}

