/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.asterisk.wrap.events;

import org.asteriskjava.manager.event.AbstractChannelEvent;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.InvalidChannelName;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.asterisk.wrap.events.ChannelEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent;
import org.asteriskjava.pbx.internal.core.AsteriskPBX;

public abstract class ChannelEventHelper
extends ManagerEvent
implements ChannelEvent {
    private static final long serialVersionUID = 1L;
    private final Channel channel;

    protected ChannelEventHelper(AbstractChannelEvent event) throws InvalidChannelName {
        this(event.getChannel(), event.getUniqueId(), event.getCallerIdNum(), event.getCallerIdName());
    }

    protected ChannelEventHelper(String channel, String uniqueId, String callerIdNum, String callerIdName) throws InvalidChannelName {
        super("");
        this.channel = channel != null ? ChannelEventHelper.registerChannel(channel, uniqueId, callerIdNum, callerIdName) : null;
    }

    public ChannelEventHelper(String channel, String uniqueId) throws InvalidChannelName {
        super("");
        AsteriskPBX pbx = (AsteriskPBX)PBXFactory.getActivePBX();
        this.channel = channel != null ? pbx.internalRegisterChannel(channel, uniqueId) : null;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    public static Channel registerChannel(String channelName, String uniqueId, String callerIdNum, String callerIdName) throws InvalidChannelName {
        AsteriskPBX pbx = (AsteriskPBX)PBXFactory.getActivePBX();
        Channel channel = pbx.internalRegisterChannel(channelName, uniqueId);
        channel.setCallerId(pbx.buildCallerID(callerIdNum, callerIdName));
        return channel;
    }
}

