/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava;

import java.io.Serializable;
import java.util.regex.Pattern;

public class AsteriskVersion
implements Comparable<AsteriskVersion>,
Serializable {
    private static final String VERSION_PATTERN_23 = "^\\s*Asterisk (GIT-)?23[-. ].*";
    private static final String VERSION_PATTERN_22 = "^\\s*Asterisk (GIT-)?22[-. ].*";
    private static final String VERSION_PATTERN_21 = "^\\s*Asterisk (GIT-)?21[-. ].*";
    private static final String VERSION_PATTERN_20 = "^\\s*Asterisk (GIT-)?20[-. ].*";
    private static final String VERSION_PATTERN_19 = "^\\s*Asterisk (GIT-)?19[-. ].*";
    private static final String VERSION_PATTERN_18 = "^\\s*Asterisk (GIT-)?18[-. ].*";
    private static final String VERSION_PATTERN_17 = "^\\s*Asterisk (GIT-)?17[-. ].*";
    private static final String VERSION_PATTERN_16 = "^\\s*Asterisk (GIT-)?16[-. ].*";
    private static final String VERSION_PATTERN_15 = "^\\s*Asterisk (GIT-)?15[-. ].*";
    private static final String VERSION_PATTERN_14 = "^\\s*Asterisk (GIT-)?14[-. ].*";
    private static final String VERSION_PATTERN_13 = "^\\s*Asterisk ((SVN-branch|GIT)-)?13[-. ].*";
    private final int version;
    private final String versionString;
    private final Pattern[] patterns;
    private static final String VERSION_PATTERN_CERTIFIED_20 = "^\\s*Asterisk certified-(GIT-)?20[-. ].*";
    private static final String VERSION_PATTERN_CERTIFIED_18 = "^\\s*Asterisk certified[-/](GIT-)?18[-. ].*";
    private static final String VERSION_PATTERN_CERTIFIED_16 = "^\\s*Asterisk certified/(GIT-)?16[-. ].*";
    private static final String VERSION_PATTERN_CERTIFIED_13 = "^\\s*Asterisk certified/((SVN-branch|GIT)-)?13[-. ].*";
    public static final AsteriskVersion ASTERISK_1_0 = new AsteriskVersion(100, "Asterisk 1.0", new String[0]);
    public static final AsteriskVersion ASTERISK_1_2 = new AsteriskVersion(120, "Asterisk 1.2", new String[0]);
    public static final AsteriskVersion ASTERISK_1_4 = new AsteriskVersion(140, "Asterisk 1.4", new String[0]);
    public static final AsteriskVersion ASTERISK_1_6 = new AsteriskVersion(160, "Asterisk 1.6", new String[0]);
    public static final AsteriskVersion ASTERISK_1_8 = new AsteriskVersion(180, "Asterisk 1.8", new String[0]);
    public static final AsteriskVersion ASTERISK_10 = new AsteriskVersion(1000, "Asterisk 10", new String[0]);
    public static final AsteriskVersion ASTERISK_11 = new AsteriskVersion(1100, "Asterisk 11", new String[0]);
    public static final AsteriskVersion ASTERISK_12 = new AsteriskVersion(1200, "Asterisk 12", new String[0]);
    public static final AsteriskVersion ASTERISK_13 = new AsteriskVersion(1300, "Asterisk 13", "^\\s*Asterisk ((SVN-branch|GIT)-)?13[-. ].*", "^\\s*Asterisk certified/((SVN-branch|GIT)-)?13[-. ].*");
    public static final AsteriskVersion ASTERISK_14 = new AsteriskVersion(1400, "Asterisk 14", "^\\s*Asterisk (GIT-)?14[-. ].*");
    public static final AsteriskVersion ASTERISK_15 = new AsteriskVersion(1500, "Asterisk 15", "^\\s*Asterisk (GIT-)?15[-. ].*");
    public static final AsteriskVersion ASTERISK_16 = new AsteriskVersion(1600, "Asterisk 16", "^\\s*Asterisk (GIT-)?16[-. ].*", "^\\s*Asterisk certified/(GIT-)?16[-. ].*");
    public static final AsteriskVersion ASTERISK_17 = new AsteriskVersion(1700, "Asterisk 17", "^\\s*Asterisk (GIT-)?17[-. ].*");
    public static final AsteriskVersion ASTERISK_18 = new AsteriskVersion(1800, "Asterisk 18", "^\\s*Asterisk (GIT-)?18[-. ].*", "^\\s*Asterisk certified[-/](GIT-)?18[-. ].*");
    public static final AsteriskVersion ASTERISK_19 = new AsteriskVersion(1900, "Asterisk 19", "^\\s*Asterisk (GIT-)?19[-. ].*");
    public static final AsteriskVersion ASTERISK_20 = new AsteriskVersion(2000, "Asterisk 20", "^\\s*Asterisk (GIT-)?20[-. ].*", "^\\s*Asterisk certified-(GIT-)?20[-. ].*");
    public static final AsteriskVersion ASTERISK_21 = new AsteriskVersion(2100, "Asterisk 21", "^\\s*Asterisk (GIT-)?21[-. ].*");
    public static final AsteriskVersion ASTERISK_22 = new AsteriskVersion(2200, "Asterisk 22", "^\\s*Asterisk (GIT-)?22[-. ].*");
    public static final AsteriskVersion ASTERISK_23 = new AsteriskVersion(2300, "Asterisk 23", "^\\s*Asterisk (GIT-)?23[-. ].*");
    private static final AsteriskVersion[] knownVersions = new AsteriskVersion[]{ASTERISK_23, ASTERISK_22, ASTERISK_21, ASTERISK_20, ASTERISK_19, ASTERISK_18, ASTERISK_17, ASTERISK_16, ASTERISK_15, ASTERISK_14, ASTERISK_13, ASTERISK_12, ASTERISK_11, ASTERISK_10, ASTERISK_1_8, ASTERISK_1_6};
    public static final AsteriskVersion DEFAULT_VERSION = ASTERISK_16;
    private static final long serialVersionUID = 1L;

    private AsteriskVersion(int version, String versionString, String ... patterns) {
        this.version = version;
        this.versionString = versionString;
        this.patterns = new Pattern[patterns.length];
        int i = 0;
        for (String pattern : patterns) {
            this.patterns[i++] = Pattern.compile(pattern);
        }
    }

    public boolean isAtLeast(AsteriskVersion o) {
        return this.version >= o.version;
    }

    @Override
    public int compareTo(AsteriskVersion o) {
        return Integer.compare(this.version, o.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsteriskVersion that = (AsteriskVersion)o;
        return this.version == that.version;
    }

    public int hashCode() {
        return this.version;
    }

    public String toString() {
        return this.versionString;
    }

    public static AsteriskVersion getDetermineVersionFromString(String coreLine) {
        for (AsteriskVersion version : knownVersions) {
            for (Pattern pattern : version.patterns) {
                if (!pattern.matcher(coreLine).matches()) continue;
                return version;
            }
        }
        return null;
    }
}

