/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import oracle.jdbc.babelfish.BabelfishConnection;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CXAResource;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.proxy._Proxy_;
import oracle.jdbc.xa.OracleXAResource;
import oracle.jdbc.xa.client.OracleXAConnection;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
public class T4CXAConnection
extends OracleXAConnection {
    public T4CXAConnection(Connection connection) throws XAException {
        super(connection);
        this.xaResource = null;
    }

    @Override
    public synchronized XAResource getXAResource() throws SQLException {
        try {
            if (this.xaResource == null) {
                OracleConnection oracleConnection = this.physicalConn instanceof BabelfishConnection ? (T4CConnection)((_Proxy_)((Object)this.physicalConn))._getDelegate_() : this.physicalConn;
                this.xaResource = new T4CXAResource(oracleConnection, this, this.isXAResourceTransLoose);
                if (this.logicalHandle != null) {
                    ((OracleXAResource)this.xaResource).setLogicalConnection(this.logicalHandle);
                }
            }
        }
        catch (XAException xAException) {
            this.xaResource = null;
            if (xAException.getCause() instanceof SQLException) {
                throw (SQLException)xAException.getCause();
            }
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), xAException);
        }
        return this.xaResource;
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }
}

