/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.model.request;

import com.github.caldav4j.CalDAVConstants;
import com.github.caldav4j.exceptions.DOMValidationException;
import com.github.caldav4j.model.request.PropProperty;
import com.github.caldav4j.model.request.TextMatch;
import com.github.caldav4j.xml.OutputsDOMBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;

public class ParamFilter
extends OutputsDOMBase {
    public static final String ELEMENT_NAME = "param-filter";
    public static final String ELEM_IS_DEFINED = "is-defined";
    public static final String ATTR_NAME = "name";
    private boolean isDefined = false;
    private TextMatch textMatch = null;
    private String name = null;

    public ParamFilter() {
    }

    public ParamFilter(String name, boolean isDefined, TextMatch textMatch) {
        this.name = name;
        this.isDefined = isDefined;
        this.textMatch = textMatch;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    protected String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    protected Namespace getNamespace() {
        return CalDAVConstants.NAMESPACE_CALDAV;
    }

    protected Collection<XmlSerializable> getChildren() {
        ArrayList<XmlSerializable> children = new ArrayList<XmlSerializable>();
        if (this.isDefined) {
            children.add((XmlSerializable)new PropProperty(ELEM_IS_DEFINED, CalDAVConstants.NAMESPACE_CALDAV));
        } else if (this.textMatch != null) {
            children.add(this.textMatch);
        }
        return children;
    }

    @Override
    protected String getTextContent() {
        return null;
    }

    @Override
    protected Map<String, String> getAttributes() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(ATTR_NAME, this.name);
        return m;
    }

    public boolean isDefined() {
        return this.isDefined;
    }

    public void setDefined(boolean isDefined) {
        this.isDefined = isDefined;
    }

    public TextMatch getTextMatch() {
        return this.textMatch;
    }

    public void setTextMatch(TextMatch textMatch) {
        this.textMatch = textMatch;
    }

    @Override
    public void validate() throws DOMValidationException {
        if (this.name == null) {
            this.throwValidationException("Name is a required property");
        }
        if (this.isDefined && this.textMatch != null) {
            this.throwValidationException("isDefined and textMatch are mutually exclusive");
        }
        if (this.textMatch != null) {
            this.textMatch.validate();
        }
    }
}

