/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.urlfragment;

import com.github.openjson.JSONException;
import com.github.openjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public abstract class UrlParametersReceivingBehavior
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    protected static final JavaScriptHeaderItem JS_REF = JavaScriptHeaderItem.forReference((ResourceReference)new PackageResourceReference(UrlParametersReceivingBehavior.class, "urlfragment.js"));
    private final Component[] components;
    private final Map<String, String> options;

    public UrlParametersReceivingBehavior(Component ... components) {
        this(new HashMap<String, String>(), components);
    }

    public UrlParametersReceivingBehavior(Map<String, String> options, Component ... components) {
        this.options = options;
        this.components = components;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        StringBuilder sb = new StringBuilder().append("try{").append("if (window.UrlUtil === undefined) {window.UrlUtil = newUrlUtil(").append(this.optionsJsonString()).append(");").append("UrlUtil.setWicketAjaxCall(function(){" + String.valueOf(this.getCallbackFunctionBody(new CallbackParameter[0])) + "});").append("$(window).bind('hashchange',window.UrlUtil.back);").append("window.UrlUtil.sendUrlParameters();}").append("}catch(e){}");
        response.render((HeaderItem)new OnDomReadyHeaderItem((CharSequence)sb.toString()));
        response.render((HeaderItem)JS_REF);
    }

    private String optionsJsonString() {
        String optionsJsonString = "";
        try {
            optionsJsonString = new JSONObject(this.options).toString();
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return optionsJsonString;
    }

    protected void respond(AjaxRequestTarget target) {
        this.onParameterArrival(RequestCycle.get().getRequest().getRequestParameters(), target);
        if (this.components != null) {
            this.addComponentsToBeRendered(target);
        }
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        attributes.getDynamicExtraParameters().add("return window.UrlUtil.joinQueryAndFragment();");
    }

    private void addComponentsToBeRendered(AjaxRequestTarget target) {
        target.add(this.components);
    }

    protected abstract void onParameterArrival(IRequestParameters var1, AjaxRequestTarget var2);
}

