/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.image;

import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import java.io.Serializable;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class Icon
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private IconBehavior iconBehavior;
    final IModel<IconType> type;

    public Icon(String componentId, IModel<IconType> type) {
        super(componentId);
        this.type = type;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Behavior[]{this.getIconBehavior()});
    }

    private IconBehavior getIconBehavior() {
        if (this.iconBehavior == null) {
            this.iconBehavior = new IconBehavior(this.type);
        }
        return this.iconBehavior;
    }

    public Icon(IModel<IconType> typeModel) {
        this("icon", typeModel);
    }

    public Icon(String id, IconType type) {
        this(id, (IModel<IconType>)Model.of((Serializable)((Object)type)));
    }

    public Icon(IconType type) {
        this("icon", (IModel<IconType>)Model.of((Serializable)((Object)type)));
    }

    public final Icon setType(IconType iconType) {
        this.getIconBehavior().setType(iconType);
        return this;
    }

    public final boolean hasIconType() {
        return this.getIconBehavior().hasIconType();
    }

    public IconType getType() {
        return this.getIconBehavior().type();
    }

    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        if (this.hasIconType() && this.getType().getTagBody() != null) {
            this.replaceComponentTagBody(markupStream, openTag, this.getType().getTagBody());
        } else {
            super.onComponentTagBody(markupStream, openTag);
        }
    }

    protected void onDetach() {
        super.onDetach();
        this.type.detach();
    }
}

