/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.search.lookup.SourceLookup;

public abstract class ArraySourceValueFetcher
implements ValueFetcher {
    private final Set<String> sourcePaths;
    @Nullable
    private final Object nullValue;

    public ArraySourceValueFetcher(String fieldName, MapperService mapperService) {
        this(fieldName, mapperService, null);
    }

    public ArraySourceValueFetcher(String fieldName, MapperService mapperService, Object nullValue) {
        this.sourcePaths = mapperService.sourcePath(fieldName);
        this.nullValue = nullValue;
    }

    @Override
    public List<Object> fetchValues(SourceLookup lookup) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String path : this.sourcePaths) {
            Object sourceValue = lookup.extractValue(path, this.nullValue);
            if (sourceValue == null) {
                return org.elasticsearch.common.collect.List.of();
            }
            values.addAll((List)this.parseSourceValue(sourceValue));
        }
        return values;
    }

    protected abstract Object parseSourceValue(Object var1);
}

