/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;
import org.apache.nifi.toolkit.client.FlowClient;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.web.api.entity.ScheduleComponentsEntity;

public class PGStart
extends AbstractNiFiCommand<VoidResult> {
    public PGStart() {
        super("pg-start", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Starts the given process group which starts any enabled and valid components contained in that group.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.PG_ID.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String pgId = this.getRequiredArg(properties, CommandOption.PG_ID);
        ScheduleComponentsEntity entity = new ScheduleComponentsEntity();
        entity.setId(pgId);
        entity.setState("RUNNING");
        FlowClient flowClient = client.getFlowClient();
        flowClient.scheduleProcessGroupComponents(pgId, entity);
        return VoidResult.getInstance();
    }
}

