/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.ott;

import jakarta.servlet.http.HttpServletRequest;
import java.time.Duration;
import org.jspecify.annotations.Nullable;
import org.springframework.security.authentication.ott.GenerateOneTimeTokenRequest;
import org.springframework.security.web.authentication.ott.GenerateOneTimeTokenRequestResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class DefaultGenerateOneTimeTokenRequestResolver
implements GenerateOneTimeTokenRequestResolver {
    private static final Duration DEFAULT_EXPIRES_IN = Duration.ofMinutes(5L);
    private Duration expiresIn = DEFAULT_EXPIRES_IN;

    @Override
    public @Nullable GenerateOneTimeTokenRequest resolve(HttpServletRequest request) {
        String username = request.getParameter("username");
        if (!StringUtils.hasText((String)username)) {
            return null;
        }
        return new GenerateOneTimeTokenRequest(username, this.expiresIn);
    }

    public void setExpiresIn(Duration expiresIn) {
        Assert.notNull((Object)expiresIn, (String)"expiresIn cannot be null");
        this.expiresIn = expiresIn;
    }
}

