/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.uuid5;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HexFormat;
import java.util.Objects;
import java.util.UUID;

public class Uuid5Util {
    private static final String NAME_DIGEST_ALGORITHM = "SHA-1";
    private static final int NAMESPACE_LENGTH = 16;
    private static final int ENCODED_LENGTH = 32;
    private static final char SEPARATOR = '-';

    public static String fromString(String name, String namespace) {
        Objects.requireNonNull(name, "Name required");
        UUID namespaceId = namespace == null ? new UUID(0L, 0L) : UUID.fromString(namespace);
        byte[] subject = name.getBytes();
        int nameLength = 16 + subject.length;
        ByteBuffer nameBuffer = ByteBuffer.allocate(nameLength);
        nameBuffer.putLong(namespaceId.getMostSignificantBits());
        nameBuffer.putLong(namespaceId.getLeastSignificantBits());
        nameBuffer.put(subject);
        byte[] nameHash = Uuid5Util.getNameHash(nameBuffer.array());
        byte[] nameUuid = Arrays.copyOf(nameHash, 16);
        nameUuid[6] = (byte)(nameUuid[6] & 0xF);
        nameUuid[6] = (byte)(nameUuid[6] | 0x50);
        nameUuid[8] = (byte)(nameUuid[8] & 0x3F);
        nameUuid[8] = (byte)(nameUuid[8] | 0xFFFFFF80);
        String encoded = HexFormat.of().formatHex(nameUuid);
        StringBuilder builder = new StringBuilder(encoded);
        while (builder.length() != 32) {
            builder.insert(0, "0");
        }
        builder.ensureCapacity(32);
        builder.insert(8, '-');
        builder.insert(13, '-');
        builder.insert(18, '-');
        builder.insert(23, '-');
        return builder.toString();
    }

    private static byte[] getNameHash(byte[] name) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(NAME_DIGEST_ALGORITHM);
            return messageDigest.digest(name);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("UUID Name Digest Algorithm not found", e);
        }
    }
}

